/***********************************************************************************************
 * Copyright (c) 2022 Obeo. All Rights Reserved.
 * This software and the attached documentation are the exclusive ownership
 * of its authors and was conceded to the profit of Obeo S.A.S.
 * This software and the attached documentation are protected under the rights
 * of intellectual ownership, including the section "Titre II  Droits des auteurs (Articles L121-1 L123-12)"
 * By installing this software, you acknowledge being aware of these rights and
 * accept them, and as a consequence you must:
 * - be in possession of a valid license of use conceded by Obeo only.
 * - agree that you have read, understood, and will comply with the license terms and conditions.
 * - agree not to do anything that could conflict with intellectual ownership owned by Obeo or its beneficiaries
 * or the authors of this software.
 *
 * Should you not agree with these terms, you must stop to use this software and give it back to its legitimate owner.
 ***********************************************************************************************/
import { GQLMessage } from '@eclipse-sirius/sirius-components-core';
export interface GQLGetProjectQueryVariables {
    projectId: string;
}
export interface GQLGetProjectQueryData {
    viewer: GQLViewer;
}
export interface GQLViewer {
    project: GQLProject;
    oslcLinkingConfiguration: string;
}
export interface GQLProject {
    id: string;
    oslcLinkingConfiguration: string;
    oslcLinkingConfigurationEnabled: boolean;
}
export interface GQLUpdateProjectOslcLinkingConfigurationMutationData {
    updateProjectOslcLinkingConfiguration: GQLUpdateProjectOslcLinkingConfigurationPayload;
}
export interface GQLUpdateProjectOslcLinkingConfigurationPayload {
    __typename: string;
}
export interface GQLUpdateProjectOslcLinkingConfigurationSuccessPayload extends GQLUpdateProjectOslcLinkingConfigurationPayload {
}
export interface GQLEnableProjectOslcLinkingConfigurationMutationData {
    enableProjectOslcLinkingConfiguration: GQLEnableProjectOslcLinkingConfigurationPayload;
}
export interface GQLEnableProjectOslcLinkingConfigurationPayload {
    __typename: string;
}
export interface GQLEnableProjectOslcLinkingConfigurationSuccessPayload extends GQLEnableProjectOslcLinkingConfigurationPayload {
    oslcLinkingConfiguration: string;
}
export interface GQLErrorPayload extends GQLEnableProjectOslcLinkingConfigurationPayload, GQLUpdateProjectOslcLinkingConfigurationPayload {
    message: string;
    messages: GQLMessage[];
}
//# sourceMappingURL=ProjectSettingsOslcLinkingView.types.d.ts.map