/***********************************************************************************************
 * Copyright (c) 2022 Obeo. All Rights Reserved.
 * This software and the attached documentation are the exclusive ownership
 * of its authors and was conceded to the profit of Obeo S.A.S.
 * This software and the attached documentation are protected under the rights
 * of intellectual ownership, including the section "Titre II  Droits des auteurs (Articles L121-1 L123-12)"
 * By installing this software, you acknowledge being aware of these rights and
 * accept them, and as a consequence you must:
 * - be in possession of a valid license of use conceded by Obeo only.
 * - agree that you have read, understood, and will comply with the license terms and conditions.
 * - agree not to do anything that could conflict with intellectual ownership owned by Obeo or its beneficiaries
 * or the authors of this software.
 *
 * Should you not agree with these terms, you must stop to use this software and give it back to its legitimate owner.
 ***********************************************************************************************/
export declare type LoadingSearchComponentProps = {
    busy: boolean;
};
export type Model = {
    id: string;
    name: string;
};
export type MetaclassDescriptor = {
    id: string;
    name: string;
    iconURL: string;
};
export interface GQLSearchResultConnection {
    edges: GQLSearchResultEdge[];
    pageInfo: GQLPageInfo;
}
export interface GQLPageInfo {
    hasPreviousPage: boolean;
    hasNextPage: boolean;
    count: number;
}
export interface GQLSearchResultEdge {
    node: GQLModelObjectSearchResult;
}
export type GQLModelObjectSearchResult = {
    id: string;
    name: string;
    metaclassName: string;
    iconURL: string;
    modelId: number;
    modelName: string;
};
export type SearchInput = {
    id: string;
    modelIds: number[];
    metaclassNames: string[];
    objectName: string;
    searchInAttributes: boolean;
    caseSensitive: boolean;
    groupByModel: boolean;
    groupByType: boolean;
};
export type GQLSearchResult = {
    searchResultConnection: GQLSearchResultConnection;
    resultGroups: GQLResultGroup[] | null;
};
export type GQLResultGroup = {
    count: number;
    label: string;
    imageURL: string;
    modelId: number;
    metaclassName: string;
    resultGroups: GQLResultGroup[] | null;
};
//# sourceMappingURL=SearchCommon.types.d.ts.map