import { GQLSearchResult, MetaclassDescriptor, SearchInput } from '../common/SearchCommon.types';
export interface FilteredSearchStateSchema {
    states: {
        filteredSearch: {
            states: {
                loading: {};
                idle: {};
                searchRequested: {};
                searching: {};
            };
        };
    };
}
export type SchemaValue = {
    filteredSearch: 'loading' | 'idle' | 'searchRequested' | 'searching';
};
export interface FilteredSearchContext {
    metaclasses: MetaclassDescriptor[] | undefined;
    searchInput: SearchInput | null;
    searchResult: GQLSearchResult | null;
}
export type HandleFetchedMetaclassesEvent = {
    type: 'HANDLE_FETCHED_METACLASSES';
    metaclasses: MetaclassDescriptor[];
};
export type SearchEvent = {
    type: 'SEARCH';
    searchInput: SearchInput;
};
export type ClearResultsEvent = {
    type: 'CLEAR_RESULTS';
};
export type SearchingEvent = {
    type: 'SEARCHING';
};
export type HandleFetchedResultEvent = {
    type: 'HANDLE_FETCHED_RESULT';
    searchResult: GQLSearchResult;
};
export type FilteredSearchEvent = HandleFetchedMetaclassesEvent | SearchEvent | ClearResultsEvent | SearchingEvent | HandleFetchedResultEvent;
export declare const filteredSearchMachine: import("xstate").StateMachine<FilteredSearchContext, FilteredSearchStateSchema, FilteredSearchEvent, any, import("xstate").BaseActionObject, import("xstate").ServiceMap, import("xstate").ResolveTypegenMeta<import("xstate").TypegenDisabled, FilteredSearchEvent, import("xstate").BaseActionObject, import("xstate").ServiceMap>>;
//# sourceMappingURL=FilteredSearchMachine.d.ts.map