import { MetaclassDescriptor, Model } from '../../common/SearchCommon.types';
export interface FiltersFormStateSchema {
    states: {
        filtersForm: {
            states: {
                loading: {};
                invalid: {};
                valid: {};
            };
        };
    };
}
export type SchemaValue = {
    filtersForm: 'loading' | 'valid' | 'invalid';
};
export interface FiltersFormContext {
    models: Model[];
    searchTerm: string | null;
    selectedModels: Model[];
    selectedMetaclasses: MetaclassDescriptor[];
    searchInAttributes: boolean;
    caseSensitive: boolean;
    groupByModel: boolean;
    groupByType: boolean;
}
export type SelectModelsEvent = {
    type: 'SELECT_MODELS';
    models: Model[];
};
export type SelectMetaclassesEvent = {
    type: 'SELECT_METACLASSES';
    metaclasses: MetaclassDescriptor[];
};
export type UpdateSearchTermEvent = {
    type: 'UPDATE_SEARCH_TERM';
    searchTerm: string | null;
};
export type ToggleSearchInAttributesEvent = {
    type: 'TOGGLE_SEARCH_IN_ATTRIBUTES';
};
export type HandleUpdatedModelsEvent = {
    type: 'HANDLE_UPDATED_MODELS';
    models: Model[];
};
export type ToggleCaseSensitiveEvent = {
    type: 'TOGGLE_CASE_SENSITIVE';
};
export type ToggleGroupByModelEvent = {
    type: 'TOGGLE_GROUP_BY_MODEL';
};
export type ToggleGroupByTypeEvent = {
    type: 'TOGGLE_GROUP_BY_TYPE';
};
export type ClearEvent = {
    type: 'CLEAR';
};
export type FiltersFormEvent = SelectModelsEvent | HandleUpdatedModelsEvent | SelectMetaclassesEvent | UpdateSearchTermEvent | ToggleSearchInAttributesEvent | ToggleCaseSensitiveEvent | ToggleGroupByModelEvent | ToggleGroupByTypeEvent | ClearEvent;
export declare const MODELS_STORAGE = "perseus.search.form.models";
export declare const METACLASSES_STORAGE = "perseus.search.form.metaclasses";
export declare const SEARCH_IN_ATTR_STORAGE = "perseus.search.form.searchInAttr";
export declare const CASE_SENSITIVE_STORAGE = "perseus.search.form.caseSensitive";
export declare const GROUP_BY_MODEL_STORAGE = "perseus.search.form.groupby.model";
export declare const GROUP_BY_TYPE_STORAGE = "perseus.search.form.groupby.type";
export declare const getInitialSelectedModels: (models: Model[]) => Model[];
export declare const getInitialSelectedMetaclasses: (metaclasses: MetaclassDescriptor[]) => MetaclassDescriptor[];
export declare const filtersFormMachine: import("xstate").StateMachine<FiltersFormContext, FiltersFormStateSchema, FiltersFormEvent, any, import("xstate").BaseActionObject, import("xstate").ServiceMap, import("xstate").ResolveTypegenMeta<import("xstate").TypegenDisabled, FiltersFormEvent, import("xstate").BaseActionObject, import("xstate").ServiceMap>>;
//# sourceMappingURL=FiltersFormMachine.d.ts.map