import { GQLSearchResult, GQLSearchResultConnection } from '../../common/SearchCommon.types';
export interface MoreResultsStateSchema {
    states: {
        moreResults: {
            states: {
                collapsed: {};
                expandRequested: {};
                expanding: {};
                expanded: {};
            };
        };
    };
}
export type SchemaValue = {
    moreResults: 'collapsed' | 'expandRequested' | 'expanding' | 'expanded';
};
export interface MoreResultsContext {
    searchResultConnection: GQLSearchResultConnection | null;
}
export type ExpandEvent = {
    type: 'EXPAND';
};
export type ExpandingEvent = {
    type: 'EXPANDING';
};
export type HandleFetchedResultEvent = {
    type: 'HANDLE_FETCHED_RESULT';
    searchResult: GQLSearchResult;
};
export type MoreResultsEvent = ExpandEvent | ExpandingEvent | HandleFetchedResultEvent;
export declare const moreResultsMachine: import("xstate").StateMachine<MoreResultsContext, MoreResultsStateSchema, MoreResultsEvent, any, import("xstate").BaseActionObject, import("xstate").ServiceMap, import("xstate").ResolveTypegenMeta<import("xstate").TypegenDisabled, MoreResultsEvent, import("xstate").BaseActionObject, import("xstate").ServiceMap>>;
//# sourceMappingURL=MoreResultsMachine.d.ts.map