import { GQLOAuthFriend } from '../../../core/oauth/OAuth.types';
import { GQLGetOAuthFriendData } from './FriendApiKeySettings.types';
export interface FriendApiKeySettingsSchema {
    states: {
        friendApiKeySettings: {
            states: {
                loading: {};
                loaded: {};
                saved: {};
                invalid: {};
            };
        };
    };
}
export type SchemaValue = {
    friendApiKeySettings: 'loading' | 'loaded' | 'saved' | 'invalid';
};
export interface FriendApiKeySettingsContext {
    friend: GQLOAuthFriend | null;
}
export type HandleFetchedFriendSuccessEvent = {
    type: 'HANDLE_FETCHED_FRIEND_SUCCESS';
    data: GQLGetOAuthFriendData;
};
export type HandleFetchedFriendErrorEvent = {
    type: 'HANDLE_FETCHED_FRIEND_ERROR';
};
export type HandleCredentialsSavedEvent = {
    type: 'HANDLE_CREDENTIALS_SAVED';
};
export type FriendApiKeySettingsEvent = HandleFetchedFriendSuccessEvent | HandleFetchedFriendErrorEvent | HandleCredentialsSavedEvent;
export declare const friendApiKeySettingsMachine: import("xstate").StateMachine<FriendApiKeySettingsContext, FriendApiKeySettingsSchema, FriendApiKeySettingsEvent, any, import("xstate").BaseActionObject, import("xstate").ServiceMap, import("xstate").ResolveTypegenMeta<import("xstate").TypegenDisabled, FriendApiKeySettingsEvent, import("xstate").BaseActionObject, import("xstate").ServiceMap>>;
//# sourceMappingURL=FriendApiKeySettingsMachine.d.ts.map