/***********************************************************************************************
 * Copyright (c) 2022 Obeo. All Rights Reserved.
 * This software and the attached documentation are the exclusive ownership
 * of its authors and was conceded to the profit of Obeo S.A.S.
 * This software and the attached documentation are protected under the rights
 * of intellectual ownership, including the section "Titre II  Droits des auteurs (Articles L121-1 L123-12)"
 * By installing this software, you acknowledge being aware of these rights and
 * accept them, and as a consequence you must:
 * - be in possession of a valid license of use conceded by Obeo only.
 * - agree that you have read, understood, and will comply with the license terms and conditions.
 * - agree not to do anything that could conflict with intellectual ownership owned by Obeo or its beneficiaries
 * or the authors of this software.
 *
 * Should you not agree with these terms, you must stop to use this software and give it back to its legitimate owner.
 ***********************************************************************************************/
import { GQLMessage } from '@eclipse-sirius/sirius-components-core';
export interface GQLGetMetaclassFiltersQueryData {
    viewer: GQLSettingsViewer;
}
export interface GQLGetMetaclassFiltersQueryVariables {
    metamodelPatterns: string[];
}
export interface GQLSettingsViewer {
    __typename: string;
    metaclassFilterSettings: GQLMetaclassFilterSettings;
}
export interface GQLMetaclassFilterSettings {
    serverDefaults: boolean;
    metaclassFilters: GQLMetaclassFilter[];
}
export interface GQLMetaclassFilter {
    metamodelPattern: string;
    metaclassNames: string[];
}
export interface GQLUpdateMetaclassFilterSettingsMutationData {
    updateMetaclassFilterSettings: GQLUpdateMetaclassFilterSettingsPayload;
}
export interface GQLUpdateMetaclassFilterSettingsPayload {
    __typename: string;
}
export interface GQLUpdateMetaclassFilterSettingsSuccessPayload extends GQLUpdateMetaclassFilterSettingsPayload {
    metaclassFilterSettings: GQLMetaclassFilterSettings;
}
export interface GQLResetMetaclassFilterSettingsMutationData {
    resetMetaclassFilterSettings: GQLResetMetaclassFilterSettingsPayload;
}
export interface GQLResetMetaclassFilterSettingsPayload {
    __typename: string;
}
export interface GQLResetMetaclassFilterSettingsSuccessPayload extends GQLResetMetaclassFilterSettingsPayload {
    metaclassFilterSettings: GQLMetaclassFilterSettings;
}
export interface GQLReloadDefaultMetaclassFilterSettingsMutationData {
    reloadDefaultMetaclassFilterSettings: GQLReloadDefaultMetaclassFilterSettingsPayload;
}
export interface GQLReloadDefaultMetaclassFilterSettingsPayload {
    __typename: string;
}
export interface GQLReloadDefaultMetaclassFilterSettingsSuccessPayload extends GQLReloadDefaultMetaclassFilterSettingsPayload {
    metaclassFilterSettings: GQLMetaclassFilterSettings;
}
export interface GQLErrorPayload extends GQLUpdateMetaclassFilterSettingsPayload, GQLReloadDefaultMetaclassFilterSettingsPayload {
    message: string;
    messages: GQLMessage[];
}
//# sourceMappingURL=MetaclassFilterSettings.types.d.ts.map