echo Installing Publication for Capella in Capella

@echo off
set CALLER_PATH=%CD%
set SCRIPT_PATH=%~dp0

REM Features relevant for installing in T4C client
set P4C_FEATURES="fr.obeo.dsl.traceability.capella.feature.feature.group,fr.obeo.perseus.client.capella.feature.feature.group,fr.obeo.dsl.traceability.cdo.feature.feature.group,fr.obeo.perseus.client.ui.feature.feature.group,fr.obeo.sirius.texttransfer.drop.feature.feature.group,fr.obeo.perseus.client.feature.feature.group,fr.obeo.dsl.traceability.feature.feature.group"

REM Features relevant for installing in plain Capella
REM set P4C_FEATURES="fr.obeo.dsl.traceability.capella.feature.feature.group,fr.obeo.perseus.client.capella.feature.feature.group,fr.obeo.perseus.client.ui.feature.feature.group,fr.obeo.sirius.texttransfer.drop.feature.feature.group,fr.obeo.perseus.client.feature.feature.group,fr.obeo.dsl.traceability.feature.feature.group"

cd "%SCRIPT_PATH%/../capella"

set WORKSPACE_NAME=installationWorkspace
set WORKSPACE_EXISTS_BEFORE=0
if exist %WORKSPACE_NAME% (
  set WORKSPACE_EXISTS_BEFORE=1
)
echo +-------------------------------------------------------+
echo + Uninstall previous Publication for Capella if present +
echo +-------------------------------------------------------+
capellac.exe ^
-nosplash -console -consoleLog ^
-data %WORKSPACE_NAME% ^
-application org.eclipse.equinox.p2.director ^
-profile DefaultProfile ^
-tag "Uninstall Previous PublicationForCapella" ^
-uninstallIU %P4C_FEATURES%

set UNINSTALL_CODE=%errorlevel%
if %UNINSTALL_CODE% == 0 (
    echo ---------------------
    echo Uninstall successful.
    echo ---------------------
) else (
    echo --------------------------------------------------------------------------------
    echo Uninstall returned code %UNINSTALL_CODE%, this is expected in many cases so proceeding anyway.
    echo --------------------------------------------------------------------------------
)

echo +-------------------------------------+
echo + Install new Publication for Capella +
echo +-------------------------------------+
@echo on
capellac.exe ^
-nosplash -console -consoleLog ^
-data %WORKSPACE_NAME% ^
-application org.eclipse.equinox.p2.director ^
-profile DefaultProfile ^
-tag "Install PublicationForCapella 2025.10.0" ^
-installIU %P4C_FEATURES% ^
-repository "jar:file:///%SCRIPT_PATH%../updateSite/fr.obeo.perseus.client.updatesite-2025.10.0.zip!"

@echo off
set INSTALL_CODE=%errorlevel%
if %INSTALL_CODE% == 0 (
    echo -------------------
    echo Install successful.
    echo -------------------
) else (
    echo ----------------------------------
    echo Install failed with exit code %INSTALL_CODE%.
    echo ----------------------------------
)

if %WORKSPACE_EXISTS_BEFORE% == 0 (
  if exist %WORKSPACE_NAME% (
    RD /S /Q %WORKSPACE_NAME%
  )
)
cd "%CALLER_PATH%"
