/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.internal.ws;

import java.net.HttpCookie;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import org.eclipse.core.net.proxy.IProxyData;
import org.eclipse.core.net.proxy.IProxyService;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jetty.client.HttpProxy;
import org.eclipse.jetty.client.Origin;
import org.eclipse.jetty.client.api.Authentication;
import org.eclipse.jetty.client.util.BasicAuthentication;
import org.eclipse.jetty.websocket.client.ClientUpgradeRequest;
import org.eclipse.jetty.websocket.client.WebSocketClient;
import org.eclipse.net4j.ILocationAware;
import org.eclipse.net4j.internal.ws.WSConnector;
import org.eclipse.net4j.util.StringUtil;
import org.eclipse.net4j.util.om.OMPlatform;
import org.eclipse.net4j.ws.jetty.Net4jWebSocket;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.util.tracker.ServiceTracker;

public class WSClientConnector
extends WSConnector {
    private static final String CLIENT_BASIC_AUTH = "org.eclipse.net4j.internal.ws.WSClientConnector.clientBasicAuth";
    protected static final long CLIENT_IDLE_TIMEOUT = OMPlatform.INSTANCE.getProperty("org.eclipse.net4j.internal.ws.WSClientConnector.clientIdleTimeout", 30000);
    private WebSocketClient client;
    protected boolean ownedClient;
    private long connectTimeout = 5000L;
    private String url;
    private URI serviceURI;
    private String acceptorName;
    private final List<HttpCookie> cookies = new ArrayList<HttpCookie>();

    public ILocationAware.Location getLocation() {
        return ILocationAware.Location.CLIENT;
    }

    public WebSocketClient getClient() {
        return this.client;
    }

    public void setClient(WebSocketClient client) {
        this.checkInactive();
        this.client = client;
    }

    public long getConnectTimeout() {
        return this.connectTimeout;
    }

    public void setConnectTimeout(long connectTimeout) {
        this.checkInactive();
        this.connectTimeout = connectTimeout;
    }

    @Override
    public URI getServiceURI() {
        return this.serviceURI;
    }

    @Override
    public String getAcceptorName() {
        return this.acceptorName;
    }

    public String getURL() {
        return this.url;
    }

    public void setURL(String url) throws URISyntaxException {
        this.checkInactive();
        this.url = url;
        URI uri = new URI(url);
        Path path = new Path(uri.getPath());
        int index = this.getAcceptorSegmentIndex((IPath)path);
        if (index == -1) {
            throw new URISyntaxException(url, "Acceptor name prefix '@' not found");
        }
        String serviceURIString = String.valueOf(uri.getScheme()) + "://" + uri.getAuthority();
        int i = 0;
        while (i < index) {
            serviceURIString = String.valueOf(serviceURIString) + "/" + path.segment(i);
            ++i;
        }
        this.serviceURI = new URI(serviceURIString);
        this.acceptorName = path.segment(index).substring("@".length());
    }

    public void setCookies(List<HttpCookie> httpCookies) {
        this.cookies.clear();
        if (httpCookies != null && !httpCookies.isEmpty()) {
            this.cookies.addAll(httpCookies);
        }
    }

    public List<HttpCookie> getCookies() {
        return Collections.unmodifiableList(this.cookies);
    }

    public String toString() {
        return MessageFormat.format("WSClientConnector[{0}]", this.getURL());
    }

    protected int getAcceptorSegmentIndex(IPath path) {
        int i = 0;
        while (i < path.segmentCount()) {
            if (path.segment(i).startsWith("@")) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    protected void configureProxy(WebSocketClient client, String proxyType) {
        IProxyData proxyData;
        Optional<IProxyService> service = this.getProxyService();
        if (service.isPresent() && service.get().isProxiesEnabled() && !StringUtil.isEmpty((String)proxyType) && (proxyData = service.get().getProxyData(proxyType)) != null && proxyData.getHost() != null) {
            Origin.Address address = new Origin.Address(proxyData.getHost(), proxyData.getPort());
            HttpProxy proxy = new HttpProxy(address, false);
            if (proxyData.isRequiresAuthentication()) {
                BasicAuthentication auth = new BasicAuthentication(proxy.getURI(), "<<ANY_REALM>>", proxyData.getUserId(), proxyData.getPassword());
                client.getHttpClient().getAuthenticationStore().addAuthentication((Authentication)auth);
                client.getHttpClient().getAuthenticationStore().addAuthenticationResult((Authentication.Result)new BasicAuthentication.BasicResult(proxy.getURI(), proxyData.getUserId(), proxyData.getPassword()));
            }
            client.getHttpClient().getProxyConfiguration().getProxies().add(proxy);
        }
    }

    private Optional<IProxyService> getProxyService() {
        BundleContext bundleContext;
        IProxyService service = null;
        Bundle bundle = FrameworkUtil.getBundle(Plugin.class);
        BundleContext bundleContext2 = bundleContext = bundle != null ? bundle.getBundleContext() : null;
        if (bundleContext != null) {
            ServiceTracker tracker = new ServiceTracker(bundleContext, IProxyService.class, null);
            tracker.open();
            service = (IProxyService)tracker.getService();
            tracker.close();
        }
        return Optional.ofNullable(service);
    }

    protected void configureBasicAuthentication(WebSocketClient client) {
        String property = OMPlatform.INSTANCE.getProperty("org.eclipse.net4j.internal.ws.WSClientConnector.clientBasicAuth.login");
        if (!StringUtil.isEmpty((String)property)) {
            BasicAuthentication.BasicResult basicResult = new BasicAuthentication.BasicResult(this.serviceURI, property, OMPlatform.INSTANCE.getProperty("org.eclipse.net4j.internal.ws.WSClientConnector.clientBasicAuth.password", ""));
            client.getHttpClient().getAuthenticationStore().addAuthenticationResult((Authentication.Result)basicResult);
        }
    }

    protected void doBeforeActivate() throws Exception {
        if (this.serviceURI == null) {
            throw new IllegalStateException("serviceURI is null");
        }
        if (this.acceptorName == null || this.acceptorName.length() == 0) {
            throw new IllegalStateException("acceptorName is null or empty");
        }
        if (this.client == null) {
            this.client = new WebSocketClient();
            this.configureProxy(this.client, "HTTP");
            this.configureBasicAuthentication(this.client);
            this.ownedClient = true;
        }
        super.doBeforeActivate();
    }

    protected void doActivate() throws Exception {
        if (this.ownedClient) {
            this.client.start();
        }
        super.doActivate();
        Net4jWebSocket webSocket = new Net4jWebSocket(this);
        this.setWebSocket(webSocket);
        ClientUpgradeRequest request = new ClientUpgradeRequest();
        request.setHeader("Net4jAcceptor", this.acceptorName);
        if (this.cookies != null) {
            for (HttpCookie cookie : this.cookies) {
                request.getCookies().add(cookie);
            }
        }
        try {
            CompletableFuture result = this.client.connect((Object)webSocket, this.serviceURI, request);
            result.get(this.connectTimeout, TimeUnit.MILLISECONDS);
        }
        catch (Exception e) {
            if (this.ownedClient && this.client != null) {
                this.client.stop();
                this.client = null;
            }
            throw e;
        }
    }

    @Override
    protected void doDeactivate() throws Exception {
        super.doDeactivate();
        if (this.ownedClient && this.client != null) {
            this.client.stop();
            this.client = null;
        }
    }
}

