/*
 * Decompiled with CFR 0.152.
 */
package com.thalesgroup.mde.melody.collab.adm.server.protocol;

import com.thalesgroup.mde.melody.collab.adm.common.net4j.AbstractRemoteAdminIndicationWithResponse;
import com.thalesgroup.mde.melody.collab.adm.common.net4j.object.AcknowledgmentObject;
import com.thalesgroup.mde.melody.collab.adm.common.net4j.object.ElementObject;
import com.thalesgroup.mde.melody.collab.adm.common.protocol.IRemoteAdminDataInput;
import com.thalesgroup.mde.melody.collab.adm.common.protocol.IRemoteAdminDataOutput;
import com.thalesgroup.mde.melody.collab.adm.server.messages.AdmServerMessages;
import com.thalesgroup.mde.melody.collab.adm.server.protocol.RemoteAdminServerProtocol;
import com.thalesgroup.mde.melody.collab.adm.services.utils.CollabAdminServices;
import java.io.IOException;
import org.eclipse.emf.cdo.server.IRepository;
import org.eclipse.net4j.signal.SignalProtocol;
import org.eclipse.net4j.util.StringUtil;
import org.eclipse.net4j.util.security.IAuthenticator;
import org.eclipse.net4j.util.security.IUserManager;
import org.eclipse.osgi.util.NLS;

public abstract class AbstractGetUserManagerIndication
extends AbstractRemoteAdminIndicationWithResponse {
    protected ElementObject element;
    protected IUserManager userManager;
    private String repositoryID;

    public AbstractGetUserManagerIndication(RemoteAdminServerProtocol protocol) {
        super((SignalProtocol)protocol, (short)201);
    }

    protected final void indicating(IRemoteAdminDataInput in) throws IOException {
        this.element = in.readElement();
        this.repositoryID = in.readString();
        this.getIndicatingData(in);
    }

    protected final void responding(IRemoteAdminDataOutput out) throws IOException {
        AcknowledgmentObject ack = null;
        if (CollabAdminServices.getRegisteredUserManagers().isEmpty()) {
            ack = new AcknowledgmentObject(false, AdmServerMessages.err_noUserManagerRegistered);
        }
        if (ack == null) {
            if (!StringUtil.isEmpty((String)this.repositoryID)) {
                IRepository repository = CollabAdminServices.getRepository((String)this.repositoryID);
                ack = new AcknowledgmentObject(repository != null, NLS.bind((String)AdmServerMessages.err_repositoryDoesNotExist, (Object)this.repositoryID));
                if (repository != null) {
                    IAuthenticator authenticator = repository.getSessionManager().getAuthenticator();
                    if (authenticator instanceof IUserManager) {
                        this.userManager = (IUserManager)authenticator;
                    } else {
                        ack = new AcknowledgmentObject(false, NLS.bind((String)AdmServerMessages.err_noUserManagerIdentified, (Object[])new Object[]{this.repositoryID, this.repositoryID}));
                    }
                }
            } else {
                this.userManager = CollabAdminServices.getUserManager((String)this.element.getType(), (String)this.element.getDescription());
                if (this.userManager == null) {
                    ack = new AcknowledgmentObject(false, NLS.bind((String)AdmServerMessages.err_noUserManagerIdentified, (Object[])new Object[]{this.element.getType(), this.element.getDescription()}));
                }
            }
        }
        if (ack == null) {
            ack = this.doExtraCheckOnUserManager(this.userManager);
        }
        out.writeAknowledgement(ack);
        if (ack != null && ack.isStatusOk()) {
            this.doResponding(out);
        }
    }

    protected AcknowledgmentObject doExtraCheckOnUserManager(IUserManager userManager) {
        return new AcknowledgmentObject(true, "");
    }

    protected void getIndicatingData(IRemoteAdminDataInput in) throws IOException {
    }

    protected abstract void doResponding(IRemoteAdminDataOutput var1) throws IOException;
}

