/*
 * Decompiled with CFR 0.152.
 */
package com.thalesgroup.mde.melody.collab.adm.server.protocol;

import com.thalesgroup.mde.melody.collab.adm.common.locks.CDOLockAreaBuffer;
import com.thalesgroup.mde.melody.collab.adm.common.net4j.AbstractRemoteAdminIndicationWithResponse;
import com.thalesgroup.mde.melody.collab.adm.common.net4j.object.AcknowledgmentObject;
import com.thalesgroup.mde.melody.collab.adm.common.protocol.IRemoteAdminDataInput;
import com.thalesgroup.mde.melody.collab.adm.common.protocol.IRemoteAdminDataOutput;
import com.thalesgroup.mde.melody.collab.adm.server.messages.AdmServerMessages;
import com.thalesgroup.mde.melody.collab.adm.server.protocol.RemoteAdminServerProtocol;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.cdo.server.CDOServerUtil;
import org.eclipse.emf.cdo.server.ISession;
import org.eclipse.emf.cdo.server.IView;
import org.eclipse.emf.cdo.server.StoreThreadLocal;
import org.eclipse.emf.cdo.spi.server.InternalRepository;
import org.eclipse.emf.cdo.spi.server.InternalSession;
import org.eclipse.emf.cdo.spi.server.InternalView;
import org.eclipse.net4j.signal.SignalProtocol;
import org.eclipse.net4j.util.container.IManagedContainer;
import org.eclipse.net4j.util.container.IPluginContainer;

public final class DeleteDurableLocksIndication
extends AbstractRemoteAdminIndicationWithResponse {
    private List<CDOLockAreaBuffer> _durableLocksToDelete;

    public DeleteDurableLocksIndication(RemoteAdminServerProtocol protocol) {
        super((SignalProtocol)protocol, (short)100);
    }

    protected void indicating(IRemoteAdminDataInput in) throws IOException {
        this._durableLocksToDelete = in.readCDOLockAreaBuffers();
    }

    protected void responding(IRemoteAdminDataOutput out) throws IOException {
        ArrayList<AcknowledgmentObject> acknowledgments = new ArrayList<AcknowledgmentObject>();
        for (CDOLockAreaBuffer current : this._durableLocksToDelete) {
            InternalRepository repository = (InternalRepository)CDOServerUtil.getRepository((IManagedContainer)IPluginContainer.INSTANCE, (String)current.getRepositoryID());
            InternalSession internalSession = repository.getSessionManager().openSession(null);
            StoreThreadLocal.setSession((InternalSession)internalSession);
            try {
                IView view = repository.getLockingManager().openView((ISession)internalSession, 0, false, current.getDurableLockingID());
                repository.unlock((InternalView)view, null, null, false);
                view.close();
                repository.getLockingManager().deleteLockArea(current.getDurableLockingID());
                acknowledgments.add(new AcknowledgmentObject(true, "---"));
            }
            catch (IllegalStateException iex_p) {
                acknowledgments.add(new AcknowledgmentObject(false, MessageFormat.format(AdmServerMessages.err_cannotDeleteRepositoryViewAlreadyOpened, current.getDurableLockingID())));
                StoreThreadLocal.release();
                internalSession.close();
                continue;
            }
            catch (Exception ex_p) {
                try {
                    acknowledgments.add(new AcknowledgmentObject(false, MessageFormat.format(AdmServerMessages.err_cannotDeleteRepository, current.getDurableLockingID())));
                    continue;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    StoreThreadLocal.release();
                    internalSession.close();
                }
            }
            StoreThreadLocal.release();
            internalSession.close();
        }
        for (AcknowledgmentObject ack : acknowledgments) {
            out.writeAknowledgement(ack);
        }
    }
}

