/*
 * Decompiled with CFR 0.152.
 */
package fr.obeo.oo15oo.oo179oo.oo6083oo;

import fr.obeo.oo15oo.oo179oo.oo6083oo.Oo43175oo;
import fr.obeo.oo15oo.oo179oo.oo6083oo.Oo43560oo;
import fr.obeo.oo15oo.oo179oo.oo6083oo.Oo43562oo;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.CmdLineParser;
import org.kohsuke.args4j.Option;

public class Oo43174oo {
    @Option(name="-port", usage="Specify the port the server should listen to.")
    private Integer port = 9999;
    @Option(name="-max", usage="Number of maximum connections the server handles. -1 means as much as possible.")
    private Integer maxConnections = -1;
    @Option(name="-verbose", usage="Increase the level of logging performed by the server, useful for debugging purpose.")
    private Boolean verbose = false;
    @Option(name="-keys", usage="Folder containing the encrypted keys. Default is the user working directory", metaVar="PATH/TO/DIR/")
    private File dataFolder = new File(System.getProperty("user.dir"));
    @Option(name="-consoleLog", usage="Redirect log to the console")
    private Boolean oo43211oo = false;
    @Option(name="-console", usage="Opens an OSGi console to get the server status. ")
    private Boolean oo43288oo = false;
    @Option(name="-httpPort", usage="Specify the port to expose the HTTP api.")
    private int httpPort = -1;
    @Option(name="-useHttps", usage="Uses https:// to expose the HTTP api.")
    private boolean httpsEnabled = false;
    @Option(name="-SSL", usage="Enable the SSL transport (disabled by default). This might be used to enable older clients to communicate with the server.")
    private Boolean enableSSL = false;

    public int getHttpPort() {
        return this.httpPort;
    }

    public void setHttpPort(int httpPort) {
        this.httpPort = httpPort;
    }

    public boolean isHttpsEnabled() {
        return this.httpsEnabled;
    }

    public void setHttpsEnabled(boolean useHttps) {
        this.httpsEnabled = useHttps;
    }

    public int getPort() {
        return this.port;
    }

    public int getMaxConnections() {
        return this.maxConnections;
    }

    public void setPort(Integer port) {
        this.port = port;
    }

    public void setMaxConnections(Integer maxConnections) {
        this.maxConnections = maxConnections;
    }

    public void setVerbose(Boolean verbose) {
        this.verbose = verbose;
    }

    public void setDataFolder(File dataFolder) {
        this.dataFolder = dataFolder;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public File getDataFolder() {
        return this.dataFolder;
    }

    public Oo43175oo createConnectionHandler() throws IOException {
        File oo43337oo = new File(this.dataFolder, "encrypted_data_0.ols");
        if (!oo43337oo.canRead()) {
            throw new IOException("The .ols files cannot be found in the specified folder : " + this.dataFolder + ". Did you specified the correct -keys path ?");
        }
        Oo43175oo oo29oo = new Oo43175oo();
        oo29oo.setDataFolder(this.dataFolder);
        oo29oo.setPort(this.port);
        oo29oo.setMaxConnections(this.maxConnections);
        oo29oo.setSSLEnablement(this.enableSSL);
        oo29oo.getLogger().setVerbose(this.isVerbose());
        return oo29oo;
    }

    public Oo43562oo createHTTPServer(Oo43175oo handler, String version) {
        if (this.getHttpPort() != -1) {
            handler.getLogger().info("HTTP port specified");
            if (this.isHttpsEnabled()) {
                handler.getLogger().info("HTTPS enabled");
            }
            Oo43562oo oo43579oo = new Oo43562oo(handler.getLogger());
            oo43579oo.launch(this.getHttpPort(), new Oo43560oo(handler, version), this.isHttpsEnabled());
            return oo43579oo;
        }
        return null;
    }

    public static Oo43174oo createCLIFromArguments(String[] args) throws IOException {
        Oo43174oo oo43176oo = new Oo43174oo();
        CmdLineParser oo9596oo = new CmdLineParser((Object)oo43176oo);
        oo9596oo.setUsageWidth(80);
        try {
            oo9596oo.parseArgument(args);
            return oo43176oo;
        }
        catch (CmdLineException e) {
            System.err.println(e.getMessage());
            oo9596oo.printUsage((OutputStream)System.err);
            System.err.println();
            return null;
        }
    }

    public static void main(String[] args) {
        block2: {
            Oo43175oo oo2714oo = null;
            try {
                Oo43174oo oo43176oo = Oo43174oo.createCLIFromArguments(args);
                oo2714oo = oo43176oo.createConnectionHandler();
                oo2714oo.getLogger().setVerbose(oo43176oo.isVerbose());
                oo2714oo.startListening();
            }
            catch (IOException e) {
                e.printStackTrace();
                if (oo2714oo == null || oo2714oo.getLogger() == null) break block2;
                oo2714oo.getLogger().error(e.getMessage());
            }
        }
    }
}

