/*
 * Decompiled with CFR 0.152.
 */
package fr.obeo.dsl.viewpoint.collab.server.admin.h2.internal;

import fr.obeo.dsl.viewpoint.collab.server.admin.h2.internal.H2AdminConfigurationHelper;
import fr.obeo.dsl.viewpoint.collab.server.admin.internal.OM;
import fr.obeo.dsl.viewpoint.collab.server.admin.internal.repository.CDOServerConfigFileUtil;
import java.io.File;
import java.util.Optional;
import org.eclipse.emf.cdo.server.IRepository;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public final class H2RepositoryManagerUtil {
    private H2RepositoryManagerUtil() {
    }

    public static Optional<IRepository> createRepositoryFromConfiguration(String repositoryName) {
        CDOServerConfigFileUtil cdoServerConfigFileUtil = CDOServerConfigFileUtil.getInstance();
        File repositoryFile = cdoServerConfigFileUtil.getRepositoryFileFromRepositoryName(repositoryName);
        IRepository repository = OM.Activator.getRepositoryConfigurator().createRepositoryFromConfigurationFile(repositoryFile, repositoryName);
        return Optional.ofNullable(repository);
    }

    public static void createTag2HandleH2Database(Document document, Element parentElement, String url) {
        Element dbAdapter = document.createElement("dbAdapter");
        dbAdapter.setAttribute("name", H2AdminConfigurationHelper.getH2DbAdapterName());
        parentElement.appendChild(dbAdapter);
        Element dataSource = document.createElement("dataSource");
        dataSource.setAttribute("class", "org.h2.jdbcx.JdbcDataSource");
        dataSource.setAttribute("uRL", url);
        dataSource.setAttribute("user", "wsa");
        parentElement.appendChild(dataSource);
    }
}

