/*
 * Decompiled with CFR 0.152.
 */
package fr.obeo.dsl.viewpoint.collab.server.admin.h2.internal;

import fr.obeo.dsl.viewpoint.collab.server.admin.internal.OM;
import java.io.File;
import java.io.IOException;
import java.net.ServerSocket;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.osgi.framework.Bundle;

public final class H2ServerProcessManager {
    private static final String THE_H2_SERVER_WAS_NOT_ABLE_TO_START = "The h2 server was not able to start.";
    private static final String H2_BIND_ADDRESS_VM_ARG = "-Dh2.bindAddress=";
    Map<String, Process> processes = new HashMap<String, Process>();
    Map<String, String> h2ServerPorts = new HashMap<String, String>();
    Map<String, Long> pids = new HashMap<String, Long>();

    private H2ServerProcessManager() {
    }

    public static H2ServerProcessManager getInstance() {
        return H2ServerProcessManagerHolder.INSTANCE;
    }

    public IStatus createNewH2ServerProcess(String host, String port, String baseDir, String xmxValue) throws IOException {
        IStatus status = this.checkPortIsAvailable(Integer.valueOf(port));
        Bundle bundle = Platform.getBundle((String)"org.h2");
        if (bundle != null && status.isOK()) {
            String[] arguments;
            String mainClass;
            File h2BundleFile = FileLocator.getBundleFile((Bundle)bundle);
            String h2ServerBindAddress = H2_BIND_ADDRESS_VM_ARG + host;
            String[] vmArguments = new String[]{"-cp", h2BundleFile.getAbsolutePath(), xmxValue, h2ServerBindAddress};
            ProcessBuilder processBuilder = this.createProcess(vmArguments, mainClass = "org.h2.tools.Server", arguments = new String[]{"-tcp", "-tcpAllowOthers", "-tcpPort", port, "-baseDir", baseDir});
            Process process = processBuilder.start();
            if (process != null) {
                long pid = process.pid();
                OM.LOG.info("Launching H2 Server (baseDir: " + baseDir + ", port: " + port + ") - Process with PID " + pid);
                this.pids.put(baseDir, pid);
                this.processes.put(baseDir, process);
                this.h2ServerPorts.put(baseDir, port);
                if (!process.isAlive()) {
                    status = new Status(4, "fr.obeo.dsl.viewpoint.collab.server.admin.h2", THE_H2_SERVER_WAS_NOT_ABLE_TO_START);
                    OM.LOG.info("Failed to launch H2 Server process - Process wih PID " + pid + " has been terminated with exit code: " + process.exitValue());
                    process.destroy();
                    this.processes.remove(baseDir);
                    this.pids.remove(baseDir);
                }
            } else {
                status = new Status(4, "fr.obeo.dsl.viewpoint.collab.server.admin.h2", THE_H2_SERVER_WAS_NOT_ABLE_TO_START);
            }
        }
        return status;
    }

    private IStatus checkPortIsAvailable(int port) {
        IStatus status = Status.OK_STATUS;
        try {
            Throwable throwable = null;
            Object var4_5 = null;
            try {
                ServerSocket serverSocket = new ServerSocket(port);
                if (serverSocket != null) {
                    serverSocket.close();
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            status = new Status(4, "fr.obeo.dsl.viewpoint.collab.server.admin.h2", e.getLocalizedMessage(), (Throwable)e);
        }
        return status;
    }

    private ProcessBuilder createProcess(String[] vmArguments, String mainClass, String[] arguments) {
        String jvm = String.valueOf(System.getProperty("java.home")) + File.separator + "bin" + File.separator + "java";
        ArrayList<String> command = new ArrayList<String>();
        command.add(jvm);
        command.addAll(Arrays.asList(vmArguments));
        command.add(mainClass);
        command.addAll(Arrays.asList(arguments));
        return new ProcessBuilder(command);
    }

    public boolean killProcess(String key) {
        boolean handled = false;
        Process process = this.processes.get(key);
        if (process != null) {
            handled = true;
            OM.LOG.info("Stopping H2 Server (baseDir: " + key + ", port: " + this.h2ServerPorts.get(key) + ") - Process with with PID " + this.pids.get(key));
            process.destroy();
            this.processes.remove(key);
            this.pids.remove(key);
            this.h2ServerPorts.remove(key);
        }
        return handled;
    }

    public boolean hasProcessFor(String key) {
        return this.processes.containsKey(key);
    }

    public boolean hasProcessForPort(String port) {
        return this.h2ServerPorts.containsValue(port);
    }

    public void shutdown() {
        for (String key : new ArrayList<String>(this.processes.keySet())) {
            this.killProcess(key);
        }
    }

    private static final class H2ServerProcessManagerHolder {
        private static final H2ServerProcessManager INSTANCE = new H2ServerProcessManager();

        private H2ServerProcessManagerHolder() {
        }
    }
}

