/*
 * Decompiled with CFR 0.152.
 */
package fr.obeo.dsl.viewpoint.collab.server.admin.api;

import fr.obeo.dsl.viewpoint.collab.server.admin.api.IRepositoryManager;
import fr.obeo.dsl.viewpoint.collab.server.admin.api.project.NewSharedModelingProject;
import fr.obeo.dsl.viewpoint.collab.server.admin.api.repository.NewRepository;
import fr.obeo.dsl.viewpoint.collab.server.admin.api.repository.RepositoryData;
import fr.obeo.dsl.viewpoint.collab.server.admin.api.user.NewUser;
import fr.obeo.dsl.viewpoint.collab.server.admin.api.user.SimpleUser;
import fr.obeo.dsl.viewpoint.collab.server.admin.internal.contribution.DefaultRepositoryManager;
import fr.obeo.dsl.viewpoint.collab.server.admin.internal.extension.repositorymanager.RepositoryManagerService;
import fr.obeo.dsl.viewpoint.collab.server.admin.internal.repository.CDORepositoryUtil;
import fr.obeo.dsl.viewpoint.collab.server.admin.internal.repository.CDOServerConfigFileUtil;
import fr.obeo.dsl.viewpoint.collab.server.admin.internal.util.StringUtil;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Pattern;

public final class AdminServletValidator {
    private static final String VALID_REPOSITORY_NAME_PATTERN = "^[-_\\p{Alnum}]+$";

    private AdminServletValidator() {
    }

    public static String validate(NewRepository repository) {
        String diagnostic = "NO_ISSUE_DIAGNOSTIC";
        String repositoryName = repository.getRepositoryName();
        String authenticationType = repository.getAuthenticationType();
        String datasourceType = repository.getDatasourceType();
        StringBuilder detectedIssues = new StringBuilder();
        String validatedRepositoryName = AdminServletValidator.validateRepositoryName(repositoryName);
        if (!"NO_ISSUE_DIAGNOSTIC".equals(validatedRepositoryName)) {
            AdminServletValidator.completeDiagnostic(detectedIssues, validatedRepositoryName);
        } else if (CDORepositoryUtil.isExistingRepository(repositoryName)) {
            AdminServletValidator.completeDiagnostic(detectedIssues, String.format("The repository %1$s already exists.", repositoryName));
        }
        String authenticationTypeDiagnostic = AdminServletValidator.validateAuthenticationType(authenticationType);
        if (!"NO_ISSUE_DIAGNOSTIC".equals(authenticationTypeDiagnostic)) {
            AdminServletValidator.completeDiagnostic(detectedIssues, authenticationTypeDiagnostic);
        } else {
            String authenticationDataDiagnostic = AdminServletValidator.validateAuthenticationData(authenticationType, repository.getAuthenticationData());
            if (!"NO_ISSUE_DIAGNOSTIC".equals(authenticationDataDiagnostic)) {
                AdminServletValidator.completeDiagnostic(detectedIssues, authenticationDataDiagnostic);
            }
        }
        String datasourceTypeDiagnostic = AdminServletValidator.validateDatasourceType(datasourceType);
        if (!"NO_ISSUE_DIAGNOSTIC".equals(datasourceTypeDiagnostic)) {
            AdminServletValidator.completeDiagnostic(detectedIssues, datasourceTypeDiagnostic);
        } else {
            String datasourceDataDiagnostic = AdminServletValidator.validateDatasourceData(datasourceType, repository.getDatasourceData());
            if (!"NO_ISSUE_DIAGNOSTIC".equals(datasourceDataDiagnostic)) {
                AdminServletValidator.completeDiagnostic(detectedIssues, datasourceDataDiagnostic);
            }
        }
        if (detectedIssues.length() > 0) {
            diagnostic = detectedIssues.toString();
        }
        return diagnostic;
    }

    private static String validateAuthenticationType(String authenticationType) {
        IRepositoryManager repositoryManager;
        String diagnostic = "NO_ISSUE_DIAGNOSTIC";
        if (!StringUtil.isEmpty(authenticationType) && (repositoryManager = RepositoryManagerService.getInstance().getRepositoryManager(authenticationType)) instanceof DefaultRepositoryManager) {
            diagnostic = String.format("The authentication type %1$s is not handled by any extensions.", authenticationType);
        }
        return diagnostic;
    }

    private static String validateAuthenticationData(String authenticationType, Map<String, Object> authenticationData) {
        String diagnostic = "NO_ISSUE_DIAGNOSTIC";
        if (StringUtil.isEmpty(authenticationType)) {
            return diagnostic;
        }
        IRepositoryManager repositoryManager = RepositoryManagerService.getInstance().getRepositoryManager(authenticationType);
        String validatedData = repositoryManager.validateData(authenticationData);
        if (!"NO_ISSUE_DIAGNOSTIC".equals(validatedData)) {
            diagnostic = validatedData;
        }
        return diagnostic;
    }

    private static String validateDatasourceType(String datasourceType) {
        String diagnostic = "NO_ISSUE_DIAGNOSTIC";
        if (StringUtil.isEmpty(datasourceType)) {
            diagnostic = "The datasource type attribute is empty.";
        } else {
            IRepositoryManager repositoryManager = RepositoryManagerService.getInstance().getRepositoryManager(datasourceType);
            if (repositoryManager instanceof DefaultRepositoryManager) {
                diagnostic = String.format("The datasource type %1$s is not handled by any extensions.", datasourceType);
            }
        }
        return diagnostic;
    }

    private static String validateDatasourceData(String datasourceType, Map<String, Object> datasourceData) {
        IRepositoryManager repositoryManager = RepositoryManagerService.getInstance().getRepositoryManager(datasourceType);
        return repositoryManager.validateData(datasourceData);
    }

    public static String validate(NewUser newUser, String repositoryName) {
        String diagnostic = "NO_ISSUE_DIAGNOSTIC";
        StringBuilder detectedIssues = new StringBuilder();
        String repositoryReadyForOperationDiagnostic = AdminServletValidator.validateRepositoryReadyForOperation(repositoryName);
        if (!"NO_ISSUE_DIAGNOSTIC".equals(repositoryReadyForOperationDiagnostic)) {
            AdminServletValidator.completeDiagnostic(detectedIssues, repositoryReadyForOperationDiagnostic);
        } else {
            String userExistsDiagnostic = AdminServletValidator.validateUserDoesNotExist(repositoryName, newUser.getId());
            if ("NO_ISSUE_DIAGNOSTIC".equals(userExistsDiagnostic)) {
                String newUserDiagnostic = AdminServletValidator.validateNewUser(newUser, repositoryName);
                if (!"NO_ISSUE_DIAGNOSTIC".equals(newUserDiagnostic)) {
                    AdminServletValidator.completeDiagnostic(detectedIssues, newUserDiagnostic);
                }
            } else {
                AdminServletValidator.completeDiagnostic(detectedIssues, userExistsDiagnostic);
            }
        }
        if (detectedIssues.length() > 0) {
            diagnostic = detectedIssues.toString();
        }
        return diagnostic;
    }

    public static String validateRepositoryReadyForOperation(String repositoryName) {
        String diagnostic = "NO_ISSUE_DIAGNOSTIC";
        String repositoryNameDiagnostic = AdminServletValidator.validateRepositoryName(repositoryName);
        if (!"NO_ISSUE_DIAGNOSTIC".equals(repositoryNameDiagnostic)) {
            diagnostic = repositoryNameDiagnostic;
        } else {
            String repositoryDiagnostic = AdminServletValidator.validateRepository(repositoryName, RequiredRepositoryStatus.STARTED);
            if (!"NO_ISSUE_DIAGNOSTIC".equals(repositoryDiagnostic)) {
                diagnostic = repositoryDiagnostic;
            }
        }
        return diagnostic;
    }

    public static String validateNewUser(NewUser newUser, String repositoryName) {
        String diagnostic;
        String userId = newUser.getId();
        if (StringUtil.isEmpty(userId)) {
            diagnostic = "The user name is empty.";
        } else {
            Optional<RepositoryData> optionalRepositoryData = CDOServerConfigFileUtil.getInstance().getRepositoryData(repositoryName);
            String authType = optionalRepositoryData.map(RepositoryData::getAuthenticationType).orElseGet(String::new);
            IRepositoryManager repositoryManager = RepositoryManagerService.getInstance().getRepositoryManager(authType);
            diagnostic = repositoryManager.validateNewUser(newUser, repositoryName);
        }
        return diagnostic;
    }

    public static String validateRepository(String repositoryName, RequiredRepositoryStatus expectedStatus) {
        String diagnostic = "NO_ISSUE_DIAGNOSTIC";
        if (!CDORepositoryUtil.isExistingRepository(repositoryName)) {
            diagnostic = String.format("The repository %1$s has not been found.", repositoryName);
        }
        if ("NO_ISSUE_DIAGNOSTIC".equals(diagnostic)) {
            diagnostic = AdminServletValidator.validateRepositoryStatus(repositoryName, expectedStatus);
        }
        return diagnostic;
    }

    public static String validateRepositoryReadyForExport(String repositoryName, boolean needsEncryption, String password, RequiredRepositoryStatus expectedStatus) {
        String diagnostic = "NO_ISSUE_DIAGNOSTIC";
        StringBuilder detectedIssues = new StringBuilder();
        String validateRepositoryStatusDiagnostic = AdminServletValidator.validateRepositoryStatus(repositoryName, expectedStatus);
        if (!"NO_ISSUE_DIAGNOSTIC".equals(validateRepositoryStatusDiagnostic)) {
            AdminServletValidator.completeDiagnostic(detectedIssues, validateRepositoryStatusDiagnostic);
        }
        if (needsEncryption && StringUtil.isEmpty(password)) {
            AdminServletValidator.completeDiagnostic(detectedIssues, "The export encryption has been requested but no password has been provided.");
        }
        if (detectedIssues.length() > 0) {
            diagnostic = detectedIssues.toString();
        }
        return diagnostic;
    }

    public static String validateRepositoryReadyForImport(String repositoryName, byte[] bytesToImport) {
        String diagnostic = "NO_ISSUE_DIAGNOSTIC";
        StringBuilder detectedIssues = new StringBuilder();
        if (bytesToImport.length <= 0) {
            AdminServletValidator.completeDiagnostic(detectedIssues, "No data has been provided for the import.");
        }
        if (CDORepositoryUtil.activeRemoteConnectionsRemain(repositoryName)) {
            List<String> activeRemoteUsers = CDORepositoryUtil.getActiveRemoteUsers(repositoryName);
            AdminServletValidator.completeDiagnostic(detectedIssues, String.format("The import will not be executed because some connections remains (%1$s)", activeRemoteUsers));
        }
        if (detectedIssues.length() > 0) {
            diagnostic = detectedIssues.toString();
        }
        return diagnostic;
    }

    public static String validateRepositoryStatus(String repositoryName, RequiredRepositoryStatus expectedStatus) {
        String diagnostic = "NO_ISSUE_DIAGNOSTIC";
        if (expectedStatus.equals((Object)RequiredRepositoryStatus.STARTED) && CDORepositoryUtil.isStopped(repositoryName)) {
            diagnostic = String.format("The repository %1$s is not started.", repositoryName);
        } else if (expectedStatus.equals((Object)RequiredRepositoryStatus.STOPPED) && CDORepositoryUtil.isStarted(repositoryName)) {
            diagnostic = String.format("The repository %1$s is not stopped.", repositoryName);
        }
        return diagnostic;
    }

    public static String validateRepositoryConfigurationFileConsistency(String repositoryName) {
        String diagnostic = "NO_ISSUE_DIAGNOSTIC";
        if (!CDOServerConfigFileUtil.getInstance().checkCDORepositoryConfigurationFile(repositoryName)) {
            diagnostic = String.format("The cdo-server.xml file of repository %1$s is not valid compared to the init.json file.", repositoryName);
        }
        return diagnostic;
    }

    public static String validateRepositoryExists(String repositoryName) {
        String diagnostic = "NO_ISSUE_DIAGNOSTIC";
        if (!CDORepositoryUtil.isExistingRepository(repositoryName)) {
            diagnostic = String.format("The repository %1$s has not been found.", repositoryName);
        }
        return diagnostic;
    }

    public static String validateRepositoryName(String repositoryName) {
        String diagnostic = "NO_ISSUE_DIAGNOSTIC";
        if (StringUtil.isEmpty(repositoryName)) {
            diagnostic = "The repository name is empty.";
        } else if (!Pattern.matches(VALID_REPOSITORY_NAME_PATTERN, repositoryName)) {
            diagnostic = String.format("The repository name %1$s is not valid.", repositoryName);
        }
        return diagnostic;
    }

    public static String validate(NewSharedModelingProject project) {
        String repositoryNameDiagnostic;
        String diagnostic = "NO_ISSUE_DIAGNOSTIC";
        String projectName = project.getProjectName();
        String repositoryName = project.getRepositoryName();
        StringBuilder detectedIssues = new StringBuilder();
        String projectNameDiagnostic = AdminServletValidator.validateProjectName(projectName);
        if (!"NO_ISSUE_DIAGNOSTIC".equals(projectNameDiagnostic)) {
            AdminServletValidator.completeDiagnostic(detectedIssues, projectNameDiagnostic);
        }
        if (!"NO_ISSUE_DIAGNOSTIC".equals(repositoryNameDiagnostic = AdminServletValidator.validateRepositoryName(repositoryName))) {
            AdminServletValidator.completeDiagnostic(detectedIssues, repositoryNameDiagnostic);
        }
        if (detectedIssues.length() != 0) {
            diagnostic = detectedIssues.toString();
        }
        return diagnostic;
    }

    public static String validateProjectName(String projectName) {
        String diagnostic = "NO_ISSUE_DIAGNOSTIC";
        if (StringUtil.isEmpty(projectName)) {
            diagnostic = "The project name is empty.";
        }
        return diagnostic;
    }

    public static String validateUserReadyForUpdate(String userName, NewUser userUpdate) {
        String userIdDiagnostic;
        String diagnostic = "NO_ISSUE_DIAGNOSTIC";
        StringBuilder detectedIssues = new StringBuilder();
        String userNameDiagnostic = AdminServletValidator.validateUserName(userName);
        if (!"NO_ISSUE_DIAGNOSTIC".equals(userNameDiagnostic)) {
            AdminServletValidator.completeDiagnostic(detectedIssues, userNameDiagnostic);
        }
        if (!"NO_ISSUE_DIAGNOSTIC".equals(userIdDiagnostic = AdminServletValidator.validateUserName(userUpdate.getId()))) {
            AdminServletValidator.completeDiagnostic(detectedIssues, "The username of the user to update is empty.");
        }
        if (!userName.equals(userUpdate.getId())) {
            AdminServletValidator.completeDiagnostic(detectedIssues, String.format("The user name of the user (%1$s) to update is not the same than the user name provided in data used to update (%2$s).", userName, userUpdate.getId()));
        }
        if (detectedIssues.length() > 0) {
            diagnostic = detectedIssues.toString();
        }
        return diagnostic;
    }

    public static String validateUserName(String userName) {
        String diagnostic = "NO_ISSUE_DIAGNOSTIC";
        if (StringUtil.isEmpty(userName)) {
            diagnostic = "The user name is empty.";
        }
        return diagnostic;
    }

    public static String validateUserExists(String repositoryName, String userName) {
        String diagnostic = "NO_ISSUE_DIAGNOSTIC";
        Optional<SimpleUser> optionalUser = CDORepositoryUtil.getUser(repositoryName, userName);
        if (!optionalUser.isPresent()) {
            diagnostic = String.format("The user %1$s has not been found in the repository %2$s.", userName, repositoryName);
        }
        return diagnostic;
    }

    public static String validateUserDoesNotExist(String repositoryName, String userName) {
        String diagnostic = "NO_ISSUE_DIAGNOSTIC";
        Optional<SimpleUser> optionalUser = CDORepositoryUtil.getUser(repositoryName, userName);
        if (optionalUser.isPresent()) {
            diagnostic = String.format("The user is already registered for repository %1$s.", repositoryName);
        }
        return diagnostic;
    }

    public static void completeDiagnostic(StringBuilder detectedIssues, String errorMessage) {
        if (detectedIssues.length() != 0) {
            detectedIssues.append(System.lineSeparator());
        }
        detectedIssues.append(errorMessage);
    }

    public static enum RequiredRepositoryStatus {
        NONE,
        STARTED,
        STOPPED;

    }
}

