/*
 * Decompiled with CFR 0.152.
 */
package fr.obeo.dsl.viewpoint.collab.server.admin.api;

import fr.obeo.dsl.viewpoint.collab.server.admin.api.AdminServerConfigurationHelper;
import fr.obeo.dsl.viewpoint.collab.server.admin.api.AdminServletValidator;
import fr.obeo.dsl.viewpoint.collab.server.admin.internal.util.StringUtil;
import java.util.LinkedHashMap;
import java.util.Map;

public final class LDAPUtil {
    private static final String LDAP_DN_PATTERN_PARAMETER = "dnPattern";
    private static final String LDAP_URL_PARAMETER = "url";
    private static final String TRUST_STORE_PASSPHRASE_AUTHENTICATION_DATA = "trustStorePassphrase";
    private static final String TRUST_STORE_PATH_AUTHENTICATION_DATA = "trustStorePath";
    private static final String IS_TLS_ENABLED_AUTHENTICATION_DATA = "isTlsEnabled";
    private static final String AUTH_LDAP_TRUSTSTORE_PASSPHRASE = "ldap.truststore.passphrase";
    private static final String AUTH_LDAP_TRUSTSTORE_PATH = "ldap.truststore.path";
    private static final String AUTH_LDAP_TLS_ENABLED = "ldap.tls.enabled";
    private static final String AUTH_LDAP_DN_PATTERN = "ldap.dn.pattern";
    private static final String AUTH_LDAP_URL = "ldap.url";
    private static final String AUTH_TYPE = "auth.type";

    private LDAPUtil() {
    }

    public static Map<String, String> addLDAPPropertiesToMap(Map<String, Object> ldapAuthenticationData, boolean isOnlyLdap) {
        LinkedHashMap<String, String> propertiesMap = new LinkedHashMap<String, String>();
        String prefix = "";
        if (!isOnlyLdap) {
            prefix = "auth.";
        }
        propertiesMap.put(AUTH_TYPE, "ldap");
        propertiesMap.put(String.valueOf(prefix) + AUTH_LDAP_URL, String.valueOf(ldapAuthenticationData.get(LDAP_URL_PARAMETER)));
        propertiesMap.put(String.valueOf(prefix) + AUTH_LDAP_DN_PATTERN, String.valueOf(ldapAuthenticationData.get(LDAP_DN_PATTERN_PARAMETER)));
        if (Boolean.valueOf(String.valueOf(ldapAuthenticationData.get(IS_TLS_ENABLED_AUTHENTICATION_DATA))).booleanValue()) {
            propertiesMap.put(String.valueOf(prefix) + AUTH_LDAP_TLS_ENABLED, String.valueOf(Boolean.TRUE));
            propertiesMap.put(String.valueOf(prefix) + AUTH_LDAP_TRUSTSTORE_PATH, String.valueOf(ldapAuthenticationData.getOrDefault(TRUST_STORE_PATH_AUTHENTICATION_DATA, AdminServerConfigurationHelper.getInstance().getLDAPTrustStorePath())));
            propertiesMap.put(String.valueOf(prefix) + AUTH_LDAP_TRUSTSTORE_PASSPHRASE, String.valueOf(ldapAuthenticationData.get(TRUST_STORE_PASSPHRASE_AUTHENTICATION_DATA)));
        } else {
            propertiesMap.put(String.valueOf(prefix) + AUTH_LDAP_TLS_ENABLED, String.valueOf(Boolean.FALSE));
        }
        return propertiesMap;
    }

    public static String validateLDAPAuthenticationData(Map<String, Object> data) {
        String diagnostic = "NO_ISSUE_DIAGNOSTIC";
        StringBuilder detectedIssues = new StringBuilder();
        Object url = data.get(LDAP_URL_PARAMETER);
        if (url == null) {
            AdminServletValidator.completeDiagnostic(detectedIssues, "The url to the ldap server is empty.");
        } else if (!(url instanceof String)) {
            AdminServletValidator.completeDiagnostic(detectedIssues, "The ldap url must be string.");
        } else if (StringUtil.isEmpty(url.toString())) {
            AdminServletValidator.completeDiagnostic(detectedIssues, "The url to the ldap server is empty.");
        }
        Object dnPattern = data.get(LDAP_DN_PATTERN_PARAMETER);
        if (dnPattern == null) {
            AdminServletValidator.completeDiagnostic(detectedIssues, "The dn pattern used to identify users over ldap is empty.");
        } else if (!(dnPattern instanceof String)) {
            AdminServletValidator.completeDiagnostic(detectedIssues, "The ldap dn pattern must be a string.");
        } else if (StringUtil.isEmpty(dnPattern.toString())) {
            AdminServletValidator.completeDiagnostic(detectedIssues, "The dn pattern used to identify users over ldap is empty.");
        }
        if (detectedIssues.length() > 0) {
            diagnostic = detectedIssues.toString();
        }
        return diagnostic;
    }
}

