/*
 * Decompiled with CFR 0.152.
 */
package fr.obeo.dsl.viewpoint.collab.server.admin.api.project;

import fr.obeo.dsl.viewpoint.collab.server.admin.api.AdminServerConfigurationHelper;
import fr.obeo.dsl.viewpoint.collab.server.admin.api.CommonUtil;
import fr.obeo.dsl.viewpoint.collab.server.admin.api.io.AbstractResponse;
import fr.obeo.dsl.viewpoint.collab.server.admin.api.io.ErrorResponse;
import fr.obeo.dsl.viewpoint.collab.server.admin.api.io.ResponseFactory;
import fr.obeo.dsl.viewpoint.collab.server.admin.api.io.WsApiExecutor;
import fr.obeo.dsl.viewpoint.collab.server.admin.api.project.DeletedProjectResponse;
import fr.obeo.dsl.viewpoint.collab.server.admin.api.project.GetProjectResponse;
import fr.obeo.dsl.viewpoint.collab.server.admin.api.project.GetProjectsResponse;
import fr.obeo.dsl.viewpoint.collab.server.admin.api.project.NewSharedModelingProject;
import fr.obeo.dsl.viewpoint.collab.server.admin.api.task.AsyncTaskWithLogResponse;
import fr.obeo.dsl.viewpoint.collab.server.admin.internal.LocalClientCall;
import fr.obeo.dsl.viewpoint.collab.server.admin.internal.project.ExportCall;
import fr.obeo.dsl.viewpoint.collab.server.admin.internal.project.ImportCall;
import fr.obeo.dsl.viewpoint.collab.server.admin.internal.repository.CDORepositoryUtil;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.stream.Collectors;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.emf.cdo.common.branch.CDOBranchPoint;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.revision.CDOList;
import org.eclipse.emf.cdo.common.util.CDOResourceNodeNotFoundException;
import org.eclipse.emf.cdo.eresource.EresourcePackage;
import org.eclipse.emf.cdo.server.IStoreAccessor;
import org.eclipse.emf.cdo.server.StoreThreadLocal;
import org.eclipse.emf.cdo.spi.common.branch.InternalCDOBranchManager;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevision;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevisionManager;
import org.eclipse.emf.cdo.spi.server.InternalRepository;
import org.eclipse.emf.cdo.spi.server.InternalStore;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EStructuralFeature;

public class SharedModelingProjectResource
extends HttpServlet {
    public static final String ALIAS = "/api/v1.0/projects/*";
    public static final String EXPORT_RESULT_SEGMENT = "/api/v1.0/exports/projects/";
    public static final String EXPORT_RESULT_ALIAS = "/api/v1.0/exports/projects/*";
    public static final String LOG_CLIENT_SEGMENT = "/api/v1.0/exports/logs/";
    public static final String LOG_CLIENT_ALIAS = "/api/v1.0/exports/logs/*";
    private static final String ERROR_BRANCHING_REPOSITORY = "Error on repository {0}: branching mode is not supported.";
    private static final String ERROR_INACTIVE_REPOSITORY = "Error on repository {0}: repository is no more active.";

    private static void assertServiceEnabled(String key, String serviceName) {
        Object enabled = AdminServerConfigurationHelper.getInstance().get(key);
        if (!CommonUtil.getBoolean(enabled, Boolean.TRUE)) {
            throw new UnsupportedOperationException(String.format("The %1s is not enabled on this server, contact your administrator.", serviceName));
        }
    }

    public static Path getExportResultResourceRoot() {
        return Paths.get(ImportCall.INSTANCE.getRootPath(), new String[0]);
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        WsApiExecutor runner = new WsApiExecutor("Listing Projects of %1$s", req, resp, String.class, String.class);
        if (runner.getPathSize() > 1) {
            String projectName = runner.getSegment(1);
            if ("*".equals(projectName)) {
                runner.setAction("Extract Projects from %1$s");
            } else {
                runner.setAction("Extract Project %2$s from %1$s");
            }
            runner.perform(args -> this.readProject(req, (String)args[0], projectName));
        } else {
            runner.perform(args -> this.listProjects(req, (String)args[0]));
        }
    }

    protected AbstractResponse readProject(HttpServletRequest req, String repoName, String projectName) throws IOException {
        SharedModelingProjectResource.assertServiceEnabled("admin.server.api.project.get.enabled", "project extraction");
        boolean isSystemPath = Boolean.parseBoolean(req.getParameter("systemPath"));
        InternalRepository repository = this.getRequiredRepository(repoName);
        String projectPath = projectName;
        List<Object> projectNames = this.doGetProjectPaths(repository).stream().map(URI::decode).collect(Collectors.toList());
        if (!"*".equals(projectName)) {
            projectPath = URI.encodeSegment((String)projectName, (boolean)false);
            if (!projectNames.contains(projectName)) {
                throw new CDOResourceNodeNotFoundException("Resource node not found: " + projectPath);
            }
            projectNames = Collections.singletonList(projectName);
        }
        try {
            ImportCall.ImportInvocation invocation = ImportCall.INSTANCE.perform(repoName, projectPath);
            List<String> resultPaths = projectNames.stream().map(it -> this.getProjectPathResult(req, invocation.getResultFile((String)it), isSystemPath)).collect(Collectors.toList());
            return new GetProjectResponse(invocation.getPid(), this.getLogURLResult(req, invocation.getLog()), resultPaths);
        }
        catch (ConcurrentModificationException cme) {
            return SharedModelingProjectResource.createBusyError("Getting project from repository has not been started.");
        }
    }

    private String getProjectPathResult(HttpServletRequest req, Path file, boolean isSystemPath) {
        if (isSystemPath) {
            return file.toAbsolutePath().normalize().toString();
        }
        String fragment = Paths.get(ImportCall.INSTANCE.getRootPath(), new String[0]).relativize(file).toString();
        String encodedFragment = URI.createFileURI((String)fragment).toString();
        return String.valueOf(req.getScheme()) + "://" + req.getServerName() + ":" + req.getServerPort() + EXPORT_RESULT_SEGMENT + encodedFragment;
    }

    private String getLogURLResult(HttpServletRequest req, Path file) {
        Path logsFolder = Paths.get(AdminServerConfigurationHelper.getInstance().getLocalClientCallLogsDirectoryPath(), "logs");
        String fragment = logsFolder.relativize(file).toString();
        String encodedFragment = URI.createFileURI((String)fragment).toString();
        return String.valueOf(req.getScheme()) + "://" + req.getServerName() + ":" + req.getServerPort() + LOG_CLIENT_SEGMENT + encodedFragment;
    }

    protected GetProjectsResponse listProjects(HttpServletRequest req, String repoName) {
        InternalRepository repository = this.getRequiredRepository(repoName);
        Collection<String> projectNames = this.doGetProjectPaths(repository);
        List<NewSharedModelingProject> projects = projectNames.stream().map(it -> {
            NewSharedModelingProject project = new NewSharedModelingProject();
            project.setRepositoryName(repoName);
            project.setProjectName(URI.decode((String)it));
            project.setPath((String)it);
            return project;
        }).collect(Collectors.toList());
        return new GetProjectsResponse(null, projects);
    }

    private InternalRepository getRequiredRepository(String repoName) {
        return CDORepositoryUtil.getRepositoryFromName(repoName).orElseThrow(() -> new NoSuchElementException("No repository: " + repoName));
    }

    protected void doDelete(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        new WsApiExecutor("Deleting Project of %1$s", req, resp, String.class, String.class).perform(args -> {
            String repoName = (String)args[0];
            String projectName = (String)args[1];
            SharedModelingProjectResource.assertServiceEnabled("admin.server.api.project.delete.enabled", "project deletion");
            InternalRepository repository = this.getRequiredRepository(repoName);
            String projectPath = URI.encodeSegment((String)projectName, (boolean)false);
            Collection<String> projectNames = this.doGetProjectPaths(repository);
            if (!projectNames.contains(projectPath)) {
                throw new CDOResourceNodeNotFoundException("Resource node not found: " + projectPath);
            }
            try {
                LocalClientCall.Invocation delete = ExportCall.INSTANCE.performDelete(repoName, projectName);
                String message = String.format("The project %2$s of %1$s deletion has been triggered.", repoName, projectName);
                DeletedProjectResponse result = new DeletedProjectResponse(delete.getPid(), this.getLogURLResult(req, delete.getLog()), message);
                result.setRepositoryName(repoName);
                result.setProjectName(projectName);
                return result;
            }
            catch (ConcurrentModificationException e) {
                return SharedModelingProjectResource.createBusyError(String.format("The project %1s has not been deleted.", projectName));
            }
        });
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        new WsApiExecutor("Post Projects", req, resp, String.class).perform(args -> {
            AbstractResponse response;
            String repoName = (String)args[0];
            String sourcePath = req.getParameter("sourcePath");
            boolean isOverrideExistingProject = Boolean.parseBoolean(req.getParameter("overrideExistingProject"));
            SharedModelingProjectResource.assertServiceEnabled("admin.server.api.project.post.enabled", "project upload");
            this.getRequiredRepository(repoName);
            try {
                LocalClientCall.Invocation export = ExportCall.INSTANCE.perform(repoName, isOverrideExistingProject, sourcePath);
                response = new AsyncTaskWithLogResponse(export.getPid(), this.getLogURLResult(req, export.getLog()));
            }
            catch (ConcurrentModificationException e) {
                response = SharedModelingProjectResource.createBusyError("Uploading Projects into the repository has not started.");
            }
            return response;
        });
    }

    private static ErrorResponse createBusyError(String task) {
        return ResponseFactory.createErrorResponse(task, 409, "Platform already busy");
    }

    private Collection<String> doGetProjectPaths(InternalRepository repo) {
        ArrayList<String> projects = new ArrayList<String>();
        if (repo.isSupportingBranches()) {
            throw new IllegalStateException(MessageFormat.format(ERROR_BRANCHING_REPOSITORY, repo.getName()));
        }
        if (!repo.isActive()) {
            throw new IllegalStateException(MessageFormat.format(ERROR_INACTIVE_REPOSITORY, repo.getName()));
        }
        CDOID rootResourceId = repo.getRootResourceID();
        InternalCDORevisionManager revisionManager = repo.getRevisionManager();
        InternalCDOBranchManager branchManager = repo.getBranchManager();
        if (revisionManager != null && branchManager != null) {
            CDOBranchPoint cdoBranch = branchManager.getMainBranch().getHead();
            InternalStore store = repo.getStore();
            IStoreAccessor reader = store.getReader(null);
            StoreThreadLocal.setAccessor((IStoreAccessor)reader);
            InternalCDORevision rootRevision = revisionManager.getRevision(rootResourceId, cdoBranch, -1, 0, true);
            Collection<InternalCDORevision> potentialProjects = this.prefetchRepoContentRevisions(revisionManager, cdoBranch, rootRevision);
            potentialProjects.stream().forEach(potentialProjectRevision -> {
                String projectNodeName = (String)potentialProjectRevision.getValue((EStructuralFeature)EresourcePackage.Literals.CDO_RESOURCE_NODE__NAME);
                projects.add(projectNodeName);
            });
            StoreThreadLocal.release();
        }
        return projects;
    }

    private Collection<InternalCDORevision> prefetchRepoContentRevisions(InternalCDORevisionManager revisionManager, CDOBranchPoint cdoBranch, InternalCDORevision repoRevision) {
        ArrayList<InternalCDORevision> potentialProjects = new ArrayList<InternalCDORevision>();
        Object contentRepo = repoRevision.getValue((EStructuralFeature)EresourcePackage.Literals.CDO_RESOURCE__CONTENTS);
        if (contentRepo instanceof CDOList) {
            for (Object firstLevelElt : (CDOList)contentRepo) {
                CDOID firstLevelEltId;
                InternalCDORevision firstLevelEltRevision;
                if (!(firstLevelElt instanceof CDOID) || !(firstLevelEltRevision = revisionManager.getRevision(firstLevelEltId = (CDOID)firstLevelElt, cdoBranch, -1, 0, true)).isResourceFolder()) continue;
                potentialProjects.add(firstLevelEltRevision);
            }
        }
        return potentialProjects;
    }
}

