/*
 * Decompiled with CFR 0.152.
 */
package fr.obeo.dsl.viewpoint.collab.server.admin.internal;

import fr.obeo.dsl.viewpoint.collab.server.admin.api.AdminServerConfigurationHelper;
import fr.obeo.dsl.viewpoint.collab.server.admin.internal.OM;
import fr.obeo.dsl.viewpoint.collab.server.admin.internal.extension.module.AdminServletRegistryListener;
import fr.obeo.dsl.viewpoint.collab.server.admin.internal.extension.repositorymanager.RepositoryManagerRegistryListener;
import fr.obeo.dsl.viewpoint.collab.server.admin.internal.repository.CDORepositoryUtil;
import fr.obeo.dsl.viewpoint.collab.server.admin.internal.util.JettyServerUtil;
import java.io.File;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IRegistryEventListener;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.cdo.spi.server.IAppExtension;
import org.eclipse.net4j.jvm.JVMUtil;
import org.eclipse.net4j.util.container.IManagedContainer;

public class AdminServerAppExtension
implements IAppExtension {
    private RepositoryManagerRegistryListener repositoryRegistryListener;
    private AdminServletRegistryListener odServletRegistryModule;

    public void start(File configFile) throws Exception {
        AdminServerConfigurationHelper adminServerConfigurationHelper;
        if (this.repositoryRegistryListener == null) {
            this.repositoryRegistryListener = new RepositoryManagerRegistryListener();
        }
        if (this.odServletRegistryModule == null) {
            this.odServletRegistryModule = new AdminServletRegistryListener();
        }
        if ((adminServerConfigurationHelper = AdminServerConfigurationHelper.getInstance()).haveToStartAdminServer()) {
            IStatus startHandledRepositories;
            String configFileFolderPath = adminServerConfigurationHelper.getRepositoriesDirectoryPath();
            OM.Activator.getDefault().initRepositoriesConfigFolder(configFileFolderPath);
            String repositoriesExportFolderPath = adminServerConfigurationHelper.getRepositoriesExportDirectoryPath();
            OM.Activator.getDefault().initRepositoriesExportFolder(repositoriesExportFolderPath);
            JVMUtil.prepareContainer((IManagedContainer)OM.Activator.getContainer());
            JVMUtil.getAcceptor((IManagedContainer)OM.Activator.getContainer(), (String)"default");
            IExtensionRegistry registry = Platform.getExtensionRegistry();
            registry.addListener((IRegistryEventListener)this.repositoryRegistryListener, "fr.obeo.dsl.viewpoint.collab.server.admin.repositoryManagerExtension");
            this.repositoryRegistryListener.parseInitialContributions();
            if (adminServerConfigurationHelper.haveToStartJetty()) {
                JettyServerUtil.startJettyServer(OM.Activator.getBundleContext());
                OM.Activator.getDefault().setJettyStarted(true);
                OM.LOG.info("REST Admin - Jetty server started.");
                if (adminServerConfigurationHelper.isAdminFromServletsEnabled()) {
                    registry.addListener((IRegistryEventListener)this.odServletRegistryModule, "fr.obeo.dsl.viewpoint.collab.server.admin.servletExtension");
                    this.odServletRegistryModule.parseInitialContributions();
                    JettyServerUtil.registerRestAdminServlets(OM.Activator.getBundleContext());
                    OM.LOG.info("REST Admin - Admin servlets started.");
                }
                if (adminServerConfigurationHelper.isNet4JWebsocketTransportEnabled()) {
                    JettyServerUtil.registerWebSocketTransport(OM.Activator.getBundleContext());
                    OM.LOG.info("REST Admin - Net4j Websocket transport started.");
                }
            }
            if (!(startHandledRepositories = CDORepositoryUtil.startHandledRepositories()).isOK()) {
                OM.LOG.error(startHandledRepositories.toString(), startHandledRepositories.getException());
            }
            OM.Activator.getDefault().setAdministrationServerStarted(true);
            OM.LOG.info("REST Admin - Administration server started.");
        }
    }

    public void stop() throws Exception {
        if (OM.Activator.getDefault().isAdministrationServerStarted()) {
            CDORepositoryUtil.stopHandledRepositories();
            OM.Activator.getDefault().setAdministrationServerStarted(false);
            OM.LOG.info("REST Admin - Administration server stopped.");
        }
        if (OM.Activator.getDefault().isJettyStarted()) {
            JettyServerUtil.stopJettyServer();
            OM.Activator.getDefault().setJettyStarted(false);
            OM.LOG.info("REST Admin - Jetty server stopped.");
        }
        this.disposePluginRegistries();
    }

    private void disposePluginRegistries() {
        if (this.repositoryRegistryListener != null) {
            this.repositoryRegistryListener.dispose();
            this.repositoryRegistryListener = null;
        }
        if (this.odServletRegistryModule != null) {
            this.odServletRegistryModule.dispose();
            this.odServletRegistryModule = null;
        }
    }
}

