/*
 * Decompiled with CFR 0.152.
 */
package fr.obeo.dsl.viewpoint.collab.server.admin.internal;

import fr.obeo.dsl.viewpoint.collab.server.admin.internal.repository.AdminRepositoryConfigurator;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.eclipse.net4j.util.container.IManagedContainer;
import org.eclipse.net4j.util.container.IPluginContainer;
import org.eclipse.net4j.util.om.OMBundle;
import org.eclipse.net4j.util.om.OMPlatform;
import org.eclipse.net4j.util.om.OSGiActivator;
import org.eclipse.net4j.util.om.log.OMLogger;
import org.osgi.framework.BundleContext;

public abstract class OM {
    public static final String BUNDLE_ID = "fr.obeo.dsl.viewpoint.collab.server.admin";
    public static final OMBundle BUNDLE = OMPlatform.INSTANCE.bundle("fr.obeo.dsl.viewpoint.collab.server.admin", OM.class);
    public static final OMLogger LOG = BUNDLE.logger();

    public static class Activator
    extends OSGiActivator {
        private static Activator activator;
        private static AdminRepositoryConfigurator repositoryConfigurator;
        private File repositoriesConfigFolder;
        private File repositoriesExportFolderPath;
        private boolean isJettyStarted;
        private boolean isAdministrationServerStarted;

        public Activator() throws IOException {
            super(BUNDLE);
            repositoryConfigurator = new AdminRepositoryConfigurator(Activator.getContainer());
        }

        protected void doStart() throws Exception {
            activator = this;
        }

        public static Activator getDefault() {
            return activator;
        }

        public static AdminRepositoryConfigurator getRepositoryConfigurator() {
            return repositoryConfigurator;
        }

        public static IManagedContainer getContainer() {
            return IPluginContainer.INSTANCE;
        }

        public static BundleContext getBundleContext() {
            return Activator.activator.bundleContext;
        }

        public void setJettyStarted(boolean isStarted) {
            this.isJettyStarted = isStarted;
        }

        public boolean isJettyStarted() {
            return this.isJettyStarted;
        }

        public void setAdministrationServerStarted(boolean isStarted) {
            this.isAdministrationServerStarted = isStarted;
        }

        public boolean isAdministrationServerStarted() {
            return this.isAdministrationServerStarted;
        }

        public File getRepositoriesConfigFolder() {
            return this.repositoriesConfigFolder;
        }

        public void initRepositoriesConfigFolder(String configFileFolderPath) throws IOException {
            Path path = Paths.get(configFileFolderPath, "repositories");
            path = path.normalize();
            File file = path.toFile();
            file.mkdirs();
            if (!file.isDirectory()) {
                throw new IOException(String.format("The %1$s path is not a directory.", file.getAbsolutePath()));
            }
            this.repositoriesConfigFolder = file;
        }

        public File getRepositoriesExportFolderPath() {
            return this.repositoriesExportFolderPath;
        }

        public void initRepositoriesExportFolder(String repositoriesExportDirectoryPath) throws IOException {
            Path exportFolderPath = Paths.get(repositoriesExportDirectoryPath, "exports");
            File exportFolderFile = exportFolderPath.toFile();
            exportFolderFile.mkdirs();
            if (!exportFolderFile.isDirectory()) {
                throw new IOException(String.format("The %1$s path is not a directory.", exportFolderFile.getAbsolutePath()));
            }
            this.repositoriesExportFolderPath = exportFolderFile;
        }
    }
}

