/*
 * Decompiled with CFR 0.152.
 */
package fr.obeo.dsl.viewpoint.collab.server.admin.internal.contribution;

import fr.obeo.dsl.viewpoint.collab.server.admin.api.AbstractRepositoryManager;
import fr.obeo.dsl.viewpoint.collab.server.admin.api.AdminServletValidator;
import fr.obeo.dsl.viewpoint.collab.server.admin.api.CommonUtil;
import fr.obeo.dsl.viewpoint.collab.server.admin.api.IRepositoryManager;
import fr.obeo.dsl.viewpoint.collab.server.admin.api.repository.RepositoryData;
import fr.obeo.dsl.viewpoint.collab.server.admin.api.user.NewUser;
import fr.obeo.dsl.viewpoint.collab.server.admin.api.user.SimpleUser;
import fr.obeo.dsl.viewpoint.collab.server.admin.internal.OM;
import fr.obeo.dsl.viewpoint.collab.server.admin.internal.repository.CDORepositoryUtil;
import fr.obeo.dsl.viewpoint.collab.server.admin.internal.repository.CDOServerConfigFileUtil;
import fr.obeo.dsl.viewpoint.collab.server.admin.internal.security.UserUtil;
import fr.obeo.dsl.viewpoint.collab.server.admin.internal.security.usermgmt.CollabFileUserManagerSpecialUserAwareManager;
import fr.obeo.dsl.viewpoint.collab.server.admin.internal.security.usermgmt.UserManagerUtil;
import fr.obeo.dsl.viewpoint.collab.server.admin.internal.util.StringUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.net4j.util.security.IUserManager;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class UserManagerAuthenticationRepositoryManager
extends AbstractRepositoryManager
implements IRepositoryManager {
    protected static final String USERS_PROPERTIES = "users.properties";
    protected static final String USERMANAGER_CONFIG_PROPERTIES_FILE = "usermanager-config.properties";
    private static final String KEY = "FILE";

    @Override
    public void manage(Document document, Element parentElement, RepositoryData repositoryData) {
        String propertiesFilePath = this.createPropertiesFile(repositoryData);
        UserManagerUtil.createXmlContent(document, parentElement, propertiesFilePath);
    }

    protected String createPropertiesFile(RepositoryData repositoryData) {
        String repositoryName = repositoryData.getRepositoryName();
        Map<String, Object> authenticationData = repositoryData.getAuthenticationData();
        String userManagerConfigurationFilePath = String.valueOf(repositoryData.getConfigurationFolderPath()) + File.separator + repositoryName + File.separator + USERMANAGER_CONFIG_PROPERTIES_FILE;
        String userPropertiesFile = String.valueOf(repositoryData.getConfigurationFolderPath()) + File.separator + repositoryName + File.separator + USERS_PROPERTIES;
        try {
            Map<String, String> usersProperties = CDORepositoryUtil.convertCredentialsToProperties((ArrayList)authenticationData.get("users"));
            CommonUtil.createProperiesFileFromMap(userPropertiesFile, usersProperties);
        }
        catch (IOException e) {
            OM.LOG.error(String.format("The users properties file (%1$s) has not been created", USERS_PROPERTIES), (Throwable)e);
        }
        LinkedHashMap<String, String> usermanagerProperties = new LinkedHashMap<String, String>();
        usermanagerProperties.put("users.file.path", userPropertiesFile);
        try {
            CommonUtil.createProperiesFileFromMap(userManagerConfigurationFilePath, usermanagerProperties);
        }
        catch (IOException e) {
            OM.LOG.error(String.format("The users manager properties file (%1$s) has not been created", USERS_PROPERTIES), (Throwable)e);
        }
        return userManagerConfigurationFilePath;
    }

    private IUserManager getUserManager(RepositoryData repositoryData) {
        return (IUserManager)OM.Activator.getContainer().getElement("org.eclipse.net4j.userManagers", "collab_file_web_services", String.valueOf(repositoryData.getConfigurationFolderPath()) + File.separator + repositoryData.getRepositoryName() + File.separator + USERMANAGER_CONFIG_PROPERTIES_FILE);
    }

    @Override
    public List<SimpleUser> getAllUsers(String repositoryName) {
        ArrayList<SimpleUser> users = new ArrayList<SimpleUser>();
        Optional<RepositoryData> repositoryData = CDOServerConfigFileUtil.getInstance().getRepositoryData(repositoryName);
        List userIds = repositoryData.map(this::getUserManager).filter(CollabFileUserManagerSpecialUserAwareManager.class::isInstance).map(CollabFileUserManagerSpecialUserAwareManager.class::cast).map(CollabFileUserManagerSpecialUserAwareManager::getUsers).orElse(Collections.emptyList());
        List simplerUsers = userIds.stream().filter(userId -> !CDORepositoryUtil.isSpecialUser(userId)).map(userId -> {
            SimpleUser simpleUser = new SimpleUser();
            simpleUser.setId((String)userId);
            return simpleUser;
        }).collect(Collectors.toList());
        users.addAll(simplerUsers);
        return users;
    }

    @Override
    public IStatus createUser(RepositoryData repositoryData, NewUser newUser) {
        IUserManager userManager = this.getUserManager(repositoryData);
        if (userManager == null) {
            return new Status(4, "fr.obeo.dsl.viewpoint.collab.server.admin", String.format("No repository manager has been found for the key %1$s.", repositoryData.getRepositoryName()));
        }
        userManager.addUser(newUser.getId(), newUser.getPassword().toCharArray());
        return Status.OK_STATUS;
    }

    @Override
    public IStatus deleteUser(RepositoryData repositoryData, String username) {
        IUserManager userManager = this.getUserManager(repositoryData);
        if (userManager != null) {
            userManager.removeUser(username);
            return Status.OK_STATUS;
        }
        return new Status(4, "fr.obeo.dsl.viewpoint.collab.server.admin", String.format("No repository manager has been found for the key %1$s.", repositoryData.getRepositoryName()));
    }

    @Override
    public String getKey() {
        return KEY;
    }

    @Override
    public String validateData(Map<String, Object> data) {
        Object users = data.get("users");
        String diagnostic = users == null ? "The list of users is empty." : (!(users instanceof Collection) ? "Users must be a collection of users." : this.validateUsersList((Collection)users));
        return diagnostic;
    }

    private String validateUsersList(Collection<?> usersList) {
        String diagnostic = "NO_ISSUE_DIAGNOSTIC";
        if (usersList.isEmpty()) {
            diagnostic = "The list of users is empty.";
        } else {
            boolean hasInvalidUsers = usersList.stream().anyMatch(obj -> !(obj instanceof Map));
            if (hasInvalidUsers) {
                diagnostic = "At least one user is invalid.";
            } else {
                Set diagnosticSet = usersList.stream().map(Map.class::cast).map(this::validateUser).filter(diag -> !"NO_ISSUE_DIAGNOSTIC".equals(diag)).collect(Collectors.toSet());
                if (!diagnosticSet.isEmpty()) {
                    diagnostic = diagnosticSet.stream().collect(Collectors.joining(System.lineSeparator()));
                }
            }
        }
        return diagnostic;
    }

    protected String validateUser(Map<String, Object> user) {
        String diagnostic = "NO_ISSUE_DIAGNOSTIC";
        StringBuilder detectedIssues = new StringBuilder();
        Object login = user.get("login");
        Object password = user.get("password");
        if (!(login instanceof String)) {
            AdminServletValidator.completeDiagnostic(detectedIssues, "At least one user login is invalid.");
        } else if (StringUtil.isEmpty(login.toString())) {
            AdminServletValidator.completeDiagnostic(detectedIssues, "At least one user login is empty.");
        }
        if (!(password instanceof String)) {
            AdminServletValidator.completeDiagnostic(detectedIssues, "At least one user password is invalid.");
        } else if (StringUtil.isEmpty(password.toString())) {
            AdminServletValidator.completeDiagnostic(detectedIssues, "At least one user password is empty.");
        }
        if (detectedIssues.length() > 0) {
            diagnostic = detectedIssues.toString();
        }
        return diagnostic;
    }

    @Override
    public String validateNewUser(NewUser newUser, String repositoryName) {
        return UserUtil.validateUserPassword(newUser.getPassword());
    }
}

