/*
 * Decompiled with CFR 0.152.
 */
package fr.obeo.dsl.viewpoint.collab.server.admin.internal.extension.repositorymanager;

import fr.obeo.dsl.viewpoint.collab.server.admin.internal.extension.repositorymanager.IRepositoryManagerDescriptor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class RepositoryManagerDescriptorRegistry {
    private static final List<IRepositoryManagerDescriptor> EXTENSIONS = new ArrayList<IRepositoryManagerDescriptor>();
    private static final Map<String, IRepositoryManagerDescriptor> KEY_TO_DESCRIPTOR_MAP = new HashMap<String, IRepositoryManagerDescriptor>();

    private RepositoryManagerDescriptorRegistry() {
    }

    public static void addExtension(IRepositoryManagerDescriptor extension) {
        EXTENSIONS.add(extension);
        KEY_TO_DESCRIPTOR_MAP.put(extension.getKeyValue(), extension);
    }

    public static void clearRegistry() {
        EXTENSIONS.clear();
        KEY_TO_DESCRIPTOR_MAP.clear();
    }

    public static List<IRepositoryManagerDescriptor> getRegisteredExtensions() {
        return new ArrayList<IRepositoryManagerDescriptor>(EXTENSIONS);
    }

    public static IRepositoryManagerDescriptor getDescriptorFromKey(String key) {
        return KEY_TO_DESCRIPTOR_MAP.get(key);
    }

    public static void removeExtension(String extensionClassName) {
        for (IRepositoryManagerDescriptor extension : RepositoryManagerDescriptorRegistry.getRegisteredExtensions()) {
            if (!extension.getExtensionClassName().equals(extensionClassName)) continue;
            EXTENSIONS.remove(extension);
            KEY_TO_DESCRIPTOR_MAP.remove(extension.getKeyValue());
        }
    }
}

