/*
 * Decompiled with CFR 0.152.
 */
package fr.obeo.dsl.viewpoint.collab.server.admin.internal.project;

import fr.obeo.dsl.viewpoint.collab.server.admin.api.AdminServerConfigurationHelper;
import fr.obeo.dsl.viewpoint.collab.server.admin.internal.LocalClientCall;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ConcurrentModificationException;
import java.util.Properties;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.core.runtime.Platform;

public final class ExportCall
extends LocalClientCall {
    public static final ExportCall INSTANCE = new ExportCall();
    private static final String REPO_ARG = "repoName";
    private static final String SRC_ARG = "sourceToExport";
    private static final String OVERRIDE_EXIST_ARG = "overrideExistingProject";
    private static final String DEL_ARG = "projectNameToDelete";

    private ExportCall() {
        super("admin.server.api.project.post.impl.config", ExportCall.getDefaultConfig());
    }

    private static Properties getDefaultConfig() {
        Properties result = new Properties();
        result.setProperty("application", "fr.obeo.dsl.viewpoint.collab.exporter");
        result.setProperty("data", Platform.getLocation().append("_export").toOSString());
        return result;
    }

    public LocalClientCall.Invocation perform(String repoName, boolean override, String path) throws IOException, ConcurrentModificationException {
        Path logsFolder = Paths.get(AdminServerConfigurationHelper.getInstance().getLocalClientCallLogsDirectoryPath(), "logs");
        File redirectedLog = Files.createTempFile(logsFolder, "ExportCall", ".log", new FileAttribute[0]).toFile();
        return new LocalClientCall.Invocation(this.runSingleInstance(() -> {
            Stream<String> args = Stream.of("-repoName", repoName, "-overrideExistingProject", Boolean.toString(override));
            if (path != null) {
                args = Stream.concat(args, Stream.of("-sourceToExport", path));
            }
            return this.execute(redirectedLog, args.collect(Collectors.toList()));
        }).pid(), redirectedLog);
    }

    public LocalClientCall.Invocation performDelete(String repoName, String projectNameToDelete) throws IOException, ConcurrentModificationException {
        Path logsFolder = Paths.get(AdminServerConfigurationHelper.getInstance().getLocalClientCallLogsDirectoryPath(), "logs");
        File redirectedLog = Files.createTempFile(logsFolder, "ExportCall", ".log", new FileAttribute[0]).toFile();
        return new LocalClientCall.Invocation(this.runSingleInstance(() -> {
            Stream<String> args = Stream.of("-repoName", repoName, "-projectNameToDelete", projectNameToDelete);
            return this.execute(redirectedLog, args.collect(Collectors.toList()));
        }).pid(), redirectedLog);
    }
}

