/*
 * Decompiled with CFR 0.152.
 */
package fr.obeo.dsl.viewpoint.collab.server.admin.internal.project;

import fr.obeo.dsl.viewpoint.collab.server.admin.api.AdminServerConfigurationHelper;
import fr.obeo.dsl.viewpoint.collab.server.admin.internal.LocalClientCall;
import fr.obeo.dsl.viewpoint.collab.server.admin.internal.util.StringUtil;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.Date;
import java.util.Properties;
import org.eclipse.core.runtime.Platform;

public final class ImportCall
extends LocalClientCall {
    public static final String ALL_PROJECTS = "*";
    public static final ImportCall INSTANCE = new ImportCall();
    private static final String REPO_ARG = "repoName";
    private static final String RESULT_EXTENSION = ".zip";
    private static final String TIMESTAMP_SYSPROPERTY = "-Dfr.obeo.viewpoint.collab.importer.internal.util.forceTimestampSuffix";
    private static final String WITH_TIMESTAMP = "addTimestampToResultFiles";
    private static final String IS_ARCHIVE = "archiveProject";
    private static final String PROJECT_ARG = "projectName";
    private static final String OUTPUT_FOLDER = "outputFolder";
    private static final String LOG_FOLDER = "logFolder";

    private ImportCall() {
        super("admin.server.api.project.get.impl.config", ImportCall.getDefaultConfig());
    }

    private static Properties getDefaultConfig() {
        Properties result = new Properties();
        result.setProperty("application", "fr.obeo.dsl.viewpoint.collab.importer");
        result.setProperty("data", Platform.getLocation().append("_import").toOSString());
        return result;
    }

    public String getRootPath() {
        String rootPath = this.getWsPath();
        String outputFolderPath = (String)this.defaulArgs.get("-outputFolder");
        if (!StringUtil.isEmpty(outputFolderPath)) {
            Path wsPath;
            Path path = Paths.get(outputFolderPath, new String[0]);
            rootPath = path.isAbsolute() ? path.toString() : ((wsPath = Paths.get(rootPath, new String[0])).isAbsolute() ? wsPath.resolve(outputFolderPath).toString() : outputFolderPath);
        }
        return rootPath;
    }

    public ImportInvocation perform(String repoName, String remoteProjectName) throws IOException, ConcurrentModificationException {
        String outputFolderPath;
        ArrayList<String> args = new ArrayList<String>();
        args.add("-repoName");
        args.add(repoName);
        if (!ALL_PROJECTS.equals(remoteProjectName)) {
            args.add("-projectName");
            args.add(remoteProjectName);
        }
        String suffix = "";
        ArrayList<String> vmArgs = new ArrayList<String>();
        if (Boolean.parseBoolean(this.defaulArgs.getOrDefault(WITH_TIMESTAMP, Boolean.toString(true)))) {
            suffix = new SimpleDateFormat("_yyyyMMdd_HHmmss").format(new Date());
            vmArgs.add("-Dfr.obeo.viewpoint.collab.importer.internal.util.forceTimestampSuffix=" + suffix);
        }
        if (!StringUtil.isEmpty(outputFolderPath = (String)this.defaulArgs.get("-outputFolder"))) {
            args.add("-outputFolder");
            args.add(Paths.get(outputFolderPath, repoName).toString());
        }
        Path logsFolder = Paths.get(AdminServerConfigurationHelper.getInstance().getLocalClientCallLogsDirectoryPath(), "logs");
        File redirectedLog = Files.createTempFile(logsFolder, "ImportCall", ".log", new FileAttribute[0]).toFile();
        return new ImportInvocation(this.runSingleInstance(() -> this.execute(redirectedLog, args, vmArgs)).pid(), repoName, suffix, redirectedLog);
    }

    public class ImportInvocation
    extends LocalClientCall.Invocation {
        final String suffix;
        private String repository;

        protected ImportInvocation(long pid, String repoName, String suffix, File log) {
            super(pid, log);
            this.suffix = Boolean.parseBoolean(ImportCall.this.defaulArgs.getOrDefault(ImportCall.IS_ARCHIVE, Boolean.toString(true))) ? String.valueOf(suffix) + ImportCall.RESULT_EXTENSION : suffix;
            this.repository = repoName;
        }

        public Path getResultFile(String projectName) {
            String outputFolderPath = (String)ImportCall.this.defaulArgs.get("-outputFolder");
            if (StringUtil.isEmpty(outputFolderPath)) {
                return Paths.get(ImportCall.this.getRootPath(), String.valueOf(projectName) + this.suffix);
            }
            return Paths.get(ImportCall.this.getRootPath(), this.repository, String.valueOf(projectName) + this.suffix);
        }
    }
}

