/*
 * Decompiled with CFR 0.152.
 */
package fr.obeo.dsl.viewpoint.collab.server.admin.internal.repository;

import fr.obeo.dsl.viewpoint.collab.server.admin.internal.OM;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.cdo.server.CDOServerUtil;
import org.eclipse.emf.cdo.server.IRepository;
import org.eclipse.emf.cdo.spi.server.RepositoryConfigurator;
import org.eclipse.net4j.util.container.IManagedContainer;
import org.eclipse.net4j.util.om.trace.ContextTracer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class AdminRepositoryConfigurator
extends RepositoryConfigurator {
    private static final String NAME_ATTRIBUTE = "name";
    private static final String REPOSITORY_TAG_NAME = "repository";
    private static final ContextTracer TRACER = new ContextTracer(org.eclipse.emf.cdo.internal.server.bundle.OM.DEBUG_REPOSITORY, AdminRepositoryConfigurator.class);
    private IManagedContainer container;

    public AdminRepositoryConfigurator(IManagedContainer container) {
        super(container);
        this.container = container;
    }

    protected IRepository configure(Document document, String repositoryName) throws CoreException {
        NodeList elements = document.getElementsByTagName(REPOSITORY_TAG_NAME);
        int i = 0;
        Element repositoryElement = null;
        while (repositoryElement == null && i < elements.getLength()) {
            Element repositoryConfig = (Element)elements.item(i);
            if (repositoryName.equals(repositoryConfig.getAttribute(NAME_ATTRIBUTE))) {
                repositoryElement = repositoryConfig;
            }
            ++i;
        }
        IRepository repository = null;
        if (repositoryElement != null) {
            repository = this.getRepository(repositoryElement);
            if (this.container != null) {
                CDOServerUtil.addRepository((IManagedContainer)this.container, (IRepository)repository);
            }
        }
        return repository;
    }

    protected IRepository configure(File configFile, String repositoryName) throws CoreException, ParserConfigurationException, SAXException, IOException {
        if (TRACER.isEnabled()) {
            TRACER.trace("Configuring CDO server from " + configFile.getAbsolutePath());
        }
        return this.configure(this.getDocument(configFile), repositoryName);
    }

    public List<String> getRepositoryNamesFromConfigurationFile(File configFile) {
        if (configFile == null || !configFile.exists()) {
            OM.LOG.info(String.format("The configuration file %1$s has not been found.", configFile.getName()));
            return Collections.emptyList();
        }
        ArrayList<String> repositoryNames = new ArrayList<String>();
        try {
            Document document = this.getDocument(configFile);
            NodeList elements = document.getElementsByTagName(REPOSITORY_TAG_NAME);
            int i = 0;
            while (i < elements.getLength()) {
                Element element = (Element)elements.item(i);
                repositoryNames.add(element.getAttribute(NAME_ATTRIBUTE));
                ++i;
            }
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            OM.LOG.error(String.format("An error occurred during the parsing of the %1$s configuration file", configFile.getName()), (Throwable)e);
        }
        return repositoryNames;
    }

    public IRepository createRepositoryFromConfigurationFile(File repositoryFile, String repositoryName) {
        IRepository repository = null;
        try {
            NodeList elements = this.getDocument(repositoryFile).getElementsByTagName(REPOSITORY_TAG_NAME);
            int i = 0;
            while (i < elements.getLength()) {
                Element element = (Element)elements.item(i);
                if (element.getAttribute(NAME_ATTRIBUTE).equals(repositoryName)) {
                    repository = this.getRepository(element);
                    break;
                }
                ++i;
            }
        }
        catch (IOException | ParserConfigurationException | CoreException | SAXException e) {
            OM.LOG.error(String.format("An error occurred during the parsing of the %1$s configuration file", repositoryFile.getName()), e);
        }
        return repository;
    }
}

