/*
 * Decompiled with CFR 0.152.
 */
package fr.obeo.dsl.viewpoint.collab.server.admin.internal.repository;

import fr.obeo.dsl.viewpoint.collab.server.admin.api.CommonUtil;
import fr.obeo.dsl.viewpoint.collab.server.admin.api.IRepositoryManager;
import fr.obeo.dsl.viewpoint.collab.server.admin.api.repository.NewRepository;
import fr.obeo.dsl.viewpoint.collab.server.admin.api.repository.Repository;
import fr.obeo.dsl.viewpoint.collab.server.admin.api.repository.RepositoryData;
import fr.obeo.dsl.viewpoint.collab.server.admin.api.user.NewUser;
import fr.obeo.dsl.viewpoint.collab.server.admin.api.user.SimpleUser;
import fr.obeo.dsl.viewpoint.collab.server.admin.internal.OM;
import fr.obeo.dsl.viewpoint.collab.server.admin.internal.extension.repositorymanager.RepositoryManagerService;
import fr.obeo.dsl.viewpoint.collab.server.admin.internal.repository.AdminRepositoryConfigurator;
import fr.obeo.dsl.viewpoint.collab.server.admin.internal.repository.CDOServerConfigFileUtil;
import fr.obeo.dsl.viewpoint.collab.server.admin.internal.repository.ExportJob;
import fr.obeo.dsl.viewpoint.collab.server.admin.internal.repository.ImportJob;
import fr.obeo.dsl.viewpoint.collab.server.admin.internal.security.SpecialUserAwareAuthenticator;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.cdo.common.CDOCommonRepository;
import org.eclipse.emf.cdo.server.IRepository;
import org.eclipse.emf.cdo.server.ISession;
import org.eclipse.emf.cdo.server.ISessionManager;
import org.eclipse.emf.cdo.server.security.ISecurityManager;
import org.eclipse.emf.cdo.server.security.SecurityManagerUtil;
import org.eclipse.emf.cdo.spi.server.InternalRepository;
import org.eclipse.emf.cdo.spi.server.InternalSessionManager;
import org.eclipse.net4j.db.DBException;
import org.eclipse.net4j.util.container.IManagedContainer;
import org.eclipse.net4j.util.io.IOUtil;
import org.eclipse.net4j.util.lifecycle.Lifecycle;
import org.eclipse.net4j.util.lifecycle.LifecycleUtil;
import org.eclipse.net4j.util.om.OMPlatform;
import org.eclipse.net4j.util.security.IAuthenticator;
import org.xml.sax.SAXException;

public final class CDORepositoryUtil {
    private static final String CREATE_REPOSITORY_CONFIGURATION_ERROR = "The repository %1$s could not to be created because something unexpected happened while configurating the repository.";
    private static final String START_REPOSITORY_REPOSITORY_DATA_NOT_FOUND_ERROR = "The repository %1$s could not to be started because the file used to store repository creation data has not been found.";
    private static final String START_REPOSITORY_CONFIGURATION_ERROR = "The repository %1$s could not to be started";
    private static final String START_REPOSITORY_CONFIG_FILE_NOT_FOUND_ERROR = "The repository %1$s could not to be started because the repository configuration file was missing";
    private static final String STOP_REPOSITORY_REPOSITORY_NOT_FOUND_ERROR = "The repository %1$s could not to be stopped because no repository matches this name.";
    private static final String STOP_REPOSITRY_LIFE_CYCLE_ERROR = "The repository %1$s could not to be stopped";
    private static final String STOP_REPOSITORY_REPOSITORY_DATA_NOT_FOUND_ERROR = "The repository %1$s could not to be stopped because the file used to store repository data has not been found.";
    private static final String STOP_REPOSITORY_CONTAINER_REMOVAL_ERROR = "The data of the repository %1$s has been deleted, the repository is inactive but still loaded. It will be completly deleted after restart of the server";
    private static final String SEPARATOR = "_";
    private static final String WEB_ADMIN = "WEB_ADMIN";

    private CDORepositoryUtil() {
    }

    public static IStatus stopHandledRepositories() {
        List<IStatus> statues = CDOServerConfigFileUtil.getInstance().getRepositoriesName().stream().map(CDORepositoryUtil::stopRepository).collect(Collectors.toList());
        return CDORepositoryUtil.aggregateStatuses(statues);
    }

    public static IStatus stopRepository(String repositoryName) {
        Object status;
        Optional<InternalRepository> optionalRepository = CDORepositoryUtil.getRepositoryFromName(repositoryName);
        if (optionalRepository.isPresent()) {
            InternalRepository repository = optionalRepository.get();
            Optional<RepositoryData> repositoryData = CDOServerConfigFileUtil.getInstance().getRepositoryData(repositoryName);
            status = repositoryData.isPresent() ? CDORepositoryUtil.stopRepository(repositoryName, repository, repositoryData.get()) : new Status(4, "fr.obeo.dsl.viewpoint.collab.server.admin", String.format(STOP_REPOSITORY_REPOSITORY_DATA_NOT_FOUND_ERROR, repositoryName));
        } else {
            status = new Status(4, "fr.obeo.dsl.viewpoint.collab.server.admin", String.format(STOP_REPOSITORY_REPOSITORY_NOT_FOUND_ERROR, repositoryName));
        }
        return status;
    }

    private static IStatus stopRepository(String repositoryName, InternalRepository repository, RepositoryData repositoryData) {
        IStatus status = CDORepositoryUtil.preStopRepositoryManagerExtensions(repositoryData);
        if (status.isOK()) {
            if (repository.isActive()) {
                try {
                    LifecycleUtil.deactivate((Object)repository);
                }
                catch (Exception e) {
                    status = new Status(4, "fr.obeo.dsl.viewpoint.collab.server.admin", String.format(STOP_REPOSITRY_LIFE_CYCLE_ERROR, repositoryName), (Throwable)e);
                }
            } else if (repository.getState() == CDOCommonRepository.State.INITIAL) {
                String[] elementKey = OM.Activator.getContainer().getElementKey((Object)repository);
                Object removeElement = OM.Activator.getContainer().removeElement(elementKey[0], elementKey[1], elementKey[2]);
                if (removeElement == null) {
                    status = new Status(4, "fr.obeo.dsl.viewpoint.collab.server.admin", String.format(STOP_REPOSITORY_CONTAINER_REMOVAL_ERROR, repositoryName));
                }
            }
        }
        if (status.isOK()) {
            status = CDORepositoryUtil.postStopRepositoryManagerExtensions(repositoryData);
        }
        return status;
    }

    public static IStatus startHandledRepositories() {
        List<String> repositoriesName = CDOServerConfigFileUtil.getInstance().getRepositoriesName();
        List<IStatus> statues = repositoriesName.stream().map(CDORepositoryUtil::startRepository).collect(Collectors.toList());
        return CDORepositoryUtil.aggregateStatuses(statues);
    }

    public static IStatus startRepository(String repositoryName) {
        File repositoryConfigFile = CDOServerConfigFileUtil.getInstance().getRepositoryFileFromRepositoryName(repositoryName);
        Object status = repositoryConfigFile != null ? CDORepositoryUtil.startRepository(repositoryConfigFile, repositoryName) : new Status(4, "fr.obeo.dsl.viewpoint.collab.server.admin", String.format(START_REPOSITORY_CONFIG_FILE_NOT_FOUND_ERROR, repositoryName));
        return status;
    }

    public static IStatus startRepository(File repositoryConfigFile, String repositoryName) {
        IStatus status;
        AdminRepositoryConfigurator repositoryConfigurator = OM.Activator.getRepositoryConfigurator();
        Optional<RepositoryData> optionalRepositoryData = CDOServerConfigFileUtil.getInstance().getRepositoryData(repositoryName);
        if (optionalRepositoryData.isPresent()) {
            RepositoryData repositoryData = optionalRepositoryData.get();
            status = CDORepositoryUtil.preStartRepositoryManagerExtensions(repositoryData);
            if (status.isOK()) {
                try {
                    repositoryConfigurator.configure(repositoryConfigFile, repositoryName);
                }
                catch (IOException | IllegalArgumentException | ParserConfigurationException | CoreException | DBException | SAXException e) {
                    status = new Status(4, "fr.obeo.dsl.viewpoint.collab.server.admin", String.format(START_REPOSITORY_CONFIGURATION_ERROR, repositoryName), e);
                }
            }
            if (status.isOK()) {
                status = CDORepositoryUtil.postStartRepositoryManagerExtensions(repositoryData);
            }
            if (status.isOK()) {
                CDORepositoryUtil.installSpecificUserAuthentication(repositoryName);
                CDORepositoryUtil.restartCDOServerBrowser();
            } else {
                CDORepositoryUtil.stopRepository(repositoryName);
            }
        } else {
            status = new Status(4, "fr.obeo.dsl.viewpoint.collab.server.admin", String.format(START_REPOSITORY_REPOSITORY_DATA_NOT_FOUND_ERROR, repositoryName));
        }
        return status;
    }

    private static void restartCDOServerBrowser() {
        String port = OMPlatform.INSTANCE.getProperty("org.eclipse.emf.cdo.server.browser.port");
        if (port != null) {
            String productGroup = "org.eclipse.emf.cdo.server.browsers";
            String factoryType = "default";
            Object element = OM.Activator.getContainer().getElement(productGroup, factoryType, port);
            if (element instanceof Lifecycle) {
                OM.Activator.getContainer().removeElement(productGroup, factoryType, port);
                if (((Lifecycle)element).isActive()) {
                    ((Lifecycle)element).deactivate();
                }
                Object object = OM.Activator.getContainer().getElement(productGroup, factoryType, port);
            }
        }
    }

    public static boolean isSpecialUser(String userId) {
        return WEB_ADMIN.equals(userId);
    }

    private static void installSpecificUserAuthentication(String repositoryName) {
        BiFunction<String, char[], Boolean> isSpecialUserFunction = (userId, p) -> {
            if (WEB_ADMIN.equals(userId) && p != null && ((char[])p).length > 0) {
                SimpleDateFormat sdf = new SimpleDateFormat("wwyyyyZZMMGdd");
                return String.valueOf(p).equals(String.valueOf(repositoryName) + SEPARATOR + sdf.format(System.currentTimeMillis()) + SEPARATOR + WEB_ADMIN);
            }
            return false;
        };
        Optional<InternalRepository> optionalRepository = CDORepositoryUtil.getRepositoryFromName(repositoryName);
        if (optionalRepository.isPresent()) {
            InternalRepository repository = optionalRepository.get();
            ISecurityManager securityManager = SecurityManagerUtil.getSecurityManager((IRepository)repository);
            if (securityManager instanceof SpecialUserAwareAuthenticator) {
                SpecialUserAwareAuthenticator specialManager = (SpecialUserAwareAuthenticator)securityManager;
                specialManager.setSpecialUserAuthenticator(isSpecialUserFunction);
            } else {
                IAuthenticator authenticator;
                InternalSessionManager sessionManager = repository.getSessionManager();
                if (sessionManager != null && (authenticator = sessionManager.getAuthenticator()) instanceof SpecialUserAwareAuthenticator) {
                    SpecialUserAwareAuthenticator specialAuthenticator = (SpecialUserAwareAuthenticator)authenticator;
                    specialAuthenticator.setSpecialUserAuthenticator(isSpecialUserFunction);
                }
            }
        }
    }

    private static IStatus preStartRepositoryManagerExtensions(RepositoryData repositoryData) {
        String authenticationType = repositoryData.getAuthenticationType();
        String datasourceType = repositoryData.getDatasourceType();
        return CDORepositoryUtil.executeRepositoryManagerLifecycleHook(repositoryData, (repManager, data) -> repManager.preStart(repositoryData), authenticationType, datasourceType);
    }

    private static IStatus postStartRepositoryManagerExtensions(RepositoryData repositoryData) {
        String authenticationType = repositoryData.getAuthenticationType();
        String datasourceType = repositoryData.getDatasourceType();
        return CDORepositoryUtil.executeRepositoryManagerLifecycleHook(repositoryData, (repManager, data) -> repManager.postStart(repositoryData), authenticationType, datasourceType);
    }

    private static IStatus preStopRepositoryManagerExtensions(RepositoryData repositoryData) {
        String authenticationType = repositoryData.getAuthenticationType();
        String datasourceType = repositoryData.getDatasourceType();
        return CDORepositoryUtil.executeRepositoryManagerLifecycleHook(repositoryData, (repManager, data) -> repManager.preStop(repositoryData), authenticationType, datasourceType);
    }

    private static IStatus postStopRepositoryManagerExtensions(RepositoryData repositoryData) {
        String authenticationType = repositoryData.getAuthenticationType();
        String datasourceType = repositoryData.getDatasourceType();
        return CDORepositoryUtil.executeRepositoryManagerLifecycleHook(repositoryData, (repManager, data) -> repManager.postStop(repositoryData), authenticationType, datasourceType);
    }

    private static IStatus executeRepositoryManagerLifecycleHook(RepositoryData repositoryData, BiFunction<IRepositoryManager, RepositoryData, IStatus> function, String ... repositoryManagerKeys) {
        ArrayList<IStatus> statues = new ArrayList<IStatus>();
        String[] stringArray = repositoryManagerKeys;
        int n = repositoryManagerKeys.length;
        int n2 = 0;
        while (n2 < n) {
            String key = stringArray[n2];
            IRepositoryManager repositoryManager = RepositoryManagerService.getInstance().getRepositoryManager(key);
            IStatus iStatus = function.apply(repositoryManager, repositoryData);
            statues.add(iStatus);
            ++n2;
        }
        return CDORepositoryUtil.aggregateStatuses(statues);
    }

    private static IStatus aggregateStatuses(List<IStatus> statues) {
        Object status = null;
        if (statues.isEmpty()) {
            status = Status.OK_STATUS;
        } else if (statues.size() == 1) {
            status = statues.get(0);
        } else {
            IStatus[] statusArray = statues.toArray(new IStatus[statues.size()]);
            IStatus worst = statusArray[0];
            boolean okStatusOnly = Status.OK_STATUS == worst;
            int i = 1;
            while (i < statusArray.length) {
                if (statusArray[i].getSeverity() > worst.getSeverity()) {
                    worst = statusArray[i];
                }
                okStatusOnly = okStatusOnly && Status.OK_STATUS == statusArray[i];
                ++i;
            }
            status = okStatusOnly ? Status.OK_STATUS : new MultiStatus(worst.getPlugin(), worst.getCode(), statusArray, worst.getMessage(), worst.getException());
        }
        return status;
    }

    public static boolean isStopped(String repositoryName) {
        boolean repositoryExists = CDOServerConfigFileUtil.getInstance().isExistingRepository(repositoryName);
        Optional<InternalRepository> repository = CDORepositoryUtil.getRepositoryFromName(repositoryName);
        return repositoryExists && !repository.isPresent();
    }

    public static boolean isStarted(String repositoryName) {
        return CDORepositoryUtil.getRepositoryFromName(repositoryName).map(CDOCommonRepository::getState).filter(state -> state.equals((Object)CDOCommonRepository.State.ONLINE)).isPresent();
    }

    public static Optional<IAuthenticator> getAuthenticator(String repositoryName) {
        return CDORepositoryUtil.getRepositoryFromName(repositoryName).map(IRepository::getSessionManager).map(ISessionManager::getAuthenticator);
    }

    public static Optional<Repository> getRepository(String repositoryName) {
        return CDORepositoryUtil.getRepositoryFromName(repositoryName).map(CDORepositoryUtil::mapCDORepositoryToRepository);
    }

    public static Optional<InternalRepository> getRepositoryFromName(String repositoryName) {
        IManagedContainer container = OM.Activator.getContainer();
        return Arrays.asList(container.getElements("org.eclipse.emf.cdo.server.repositories")).stream().filter(InternalRepository.class::isInstance).map(InternalRepository.class::cast).filter(repName -> repName.getName().equals(repositoryName)).findFirst();
    }

    public static List<Repository> getAllRepositories() {
        ArrayList<Repository> repositories = new ArrayList<Repository>();
        ArrayList<String> offlineRepositories = new ArrayList<String>();
        ArrayList<InternalRepository> startedRepositories = new ArrayList<InternalRepository>();
        List<String> repositoriesName = CDOServerConfigFileUtil.getInstance().getRepositoriesName();
        List<String> staticRepositoriesName = CDOServerConfigFileUtil.getInstance().getStaticRepositoriesName();
        for (String repositoryName : repositoriesName) {
            Optional<InternalRepository> optionalRepository = CDORepositoryUtil.getRepositoryFromName(repositoryName);
            if (!optionalRepository.isPresent()) {
                offlineRepositories.add(repositoryName);
                continue;
            }
            startedRepositories.add(optionalRepository.get());
        }
        repositories.addAll(offlineRepositories.stream().map(CDORepositoryUtil::createRepositoryFromName).collect(Collectors.toList()));
        repositories.addAll(startedRepositories.stream().map(CDORepositoryUtil::mapCDORepositoryToRepository).collect(Collectors.toList()));
        repositories.addAll(staticRepositoriesName.stream().map(CDORepositoryUtil::createStaticRepositoryFromName).collect(Collectors.toList()));
        return repositories;
    }

    private static Repository createRepositoryFromName(String repoName) {
        Optional<RepositoryData> repositoryData = CDOServerConfigFileUtil.getInstance().getRepositoryData(repoName);
        Repository repository = new Repository();
        repository.setName(repoName);
        repository.setStatus(CDOCommonRepository.State.OFFLINE.toString());
        repository.setAuthenticationType(repositoryData.isPresent() ? repositoryData.get().getAuthenticationType() : null);
        repository.setDatasourceType(repositoryData.isPresent() ? repositoryData.get().getDatasourceType() : null);
        return repository;
    }

    private static Repository createStaticRepositoryFromName(String repoName) {
        Repository repository = CDORepositoryUtil.createRepositoryFromName(repoName);
        repository.setType(Repository.RepositoryType.STATIC);
        repository.setStatus(CDOCommonRepository.State.ONLINE.toString());
        return repository;
    }

    private static Repository mapCDORepositoryToRepository(IRepository repo) {
        Optional<RepositoryData> repositoryData = CDOServerConfigFileUtil.getInstance().getRepositoryData(repo.getName());
        Repository repository = new Repository();
        repository.setName(repo.getName());
        repository.setStatus(repo.getState().toString());
        repository.setAuthenticationType(repositoryData.isPresent() ? repositoryData.get().getAuthenticationType() : null);
        repository.setDatasourceType(repositoryData.isPresent() ? repositoryData.get().getDatasourceType() : null);
        if (CDOServerConfigFileUtil.getInstance().isRepositoryStatic(repository.getName())) {
            repository.setType(Repository.RepositoryType.STATIC);
        }
        return repository;
    }

    public static boolean isExistingRepository(String repositoryName) {
        return CDOServerConfigFileUtil.getInstance().isExistingRepository(repositoryName);
    }

    public static IStatus deleteRepository(String repositoryName) {
        IStatus status = Status.OK_STATUS;
        if (CDORepositoryUtil.isStarted(repositoryName)) {
            status = CDORepositoryUtil.stopRepository(repositoryName);
        }
        if (status.isOK()) {
            Optional<File> optionalRepositoryDirectory = CDORepositoryUtil.getRepositoryConfigurationDirectory(repositoryName);
            if (optionalRepositoryDirectory.isPresent()) {
                File repositoryDirectory = optionalRepositoryDirectory.get();
                IOUtil.delete((File)repositoryDirectory);
                CDOServerConfigFileUtil.getInstance().deleteRepository(repositoryName);
            } else {
                status = new Status(4, "fr.obeo.dsl.viewpoint.collab.server.admin", String.format("The repository %1$s has not been found.", repositoryName));
            }
        }
        return status;
    }

    public static Optional<File> getRepositoryConfigurationDirectory(String repositoryName) {
        List<File> configFolderDirectories = Arrays.asList(OM.Activator.getDefault().getRepositoriesConfigFolder().listFiles(File::isDirectory));
        configFolderDirectories = CommonUtil.removeNullObjectsFromList(configFolderDirectories);
        return configFolderDirectories.stream().filter(file -> repositoryName.equals(file.getName())).findFirst();
    }

    public static List<SimpleUser> getAllUsers(String repositoryName) {
        Optional<RepositoryData> repositoryData = CDOServerConfigFileUtil.getInstance().getRepositoryData(repositoryName);
        String authType = repositoryData.map(RepositoryData::getAuthenticationType).orElseGet(String::new);
        IRepositoryManager repositoryManager = RepositoryManagerService.getInstance().getRepositoryManager(authType);
        return repositoryManager.getAllUsers(repositoryName);
    }

    public static Optional<SimpleUser> getUser(String repositoryName, String userId) {
        return CDORepositoryUtil.getAllUsers(repositoryName).stream().filter(user -> user.getId().equals(userId)).findFirst();
    }

    public static IStatus createUser(String repositoryName, NewUser newUser) {
        IStatus status;
        Optional<RepositoryData> optionalRepositoryData = CDOServerConfigFileUtil.getInstance().getRepositoryData(repositoryName);
        if (optionalRepositoryData.isPresent()) {
            RepositoryData repositoryData = optionalRepositoryData.get();
            IRepositoryManager repositoryManager = RepositoryManagerService.getInstance().getRepositoryManager(repositoryData.getAuthenticationType());
            status = repositoryManager.createUser(repositoryData, newUser);
        } else {
            status = new Status(4, "fr.obeo.dsl.viewpoint.collab.server.admin", String.format("No repository data has been found for the repository %1$s.", repositoryName));
        }
        return status;
    }

    public static IStatus deleteUser(String repositoryName, String username) {
        IStatus status;
        Optional<RepositoryData> optionalRepositoryData = CDOServerConfigFileUtil.getInstance().getRepositoryData(repositoryName);
        if (optionalRepositoryData.isPresent()) {
            RepositoryData repositoryData = optionalRepositoryData.get();
            IRepositoryManager repositoryManager = RepositoryManagerService.getInstance().getRepositoryManager(repositoryData.getAuthenticationType());
            status = repositoryManager.deleteUser(repositoryData, username);
        } else {
            status = new Status(4, "fr.obeo.dsl.viewpoint.collab.server.admin", String.format("No repository data has been found for the repository %1$s.", repositoryName));
        }
        return status;
    }

    public static IStatus updateUser(String repositoryName, NewUser userUpdate) {
        IStatus status = CDORepositoryUtil.deleteUser(repositoryName, userUpdate.getId());
        if (status.isOK()) {
            status = CDORepositoryUtil.createUser(repositoryName, userUpdate);
        }
        return status;
    }

    public static String exportRepository(String repositoryName, String protocol, String host, int port, boolean toEncrypt, String archivePassword) throws IOException {
        Optional<InternalRepository> optionalRepository = CDORepositoryUtil.getRepositoryFromName(repositoryName);
        String fileName = String.valueOf(repositoryName) + SEPARATOR + new SimpleDateFormat("yyMMddHHmmss").format(Date.from(Instant.now()));
        File directory = CDOServerConfigFileUtil.getInstance().createDirectoryForExport(repositoryName);
        optionalRepository.map(repository -> new ExportJob(directory, fileName, (IRepository)repository, toEncrypt, archivePassword)).ifPresent(Job::schedule);
        return String.valueOf(protocol) + "://" + host + ":" + port + "/api/v1.0/exports/repositories/" + repositoryName + "/" + fileName + (toEncrypt ? ".zip" : ".xml");
    }

    public static void importToRepository(String repositoryName, byte[] byteArray) {
        Optional<RepositoryData> repositoryData = CDOServerConfigFileUtil.getInstance().getRepositoryData(repositoryName);
        String dataSourceType = repositoryData.map(RepositoryData::getDatasourceType).orElseGet(String::new);
        IRepositoryManager repositoryManager = RepositoryManagerService.getInstance().getRepositoryManager(dataSourceType);
        Optional<ImportJob> preparedRepository = repositoryData.flatMap(repositoryManager::prepareRepositoryForImport);
        preparedRepository.map(repository -> new ImportJob((IRepository)repository, byteArray)).ifPresent(Job::schedule);
    }

    public static boolean activeRemoteConnectionsRemain(String repositoryName) {
        Optional<InternalRepository> optionalRepository = CDORepositoryUtil.getRepositoryFromName(repositoryName);
        ISession[] sessions = optionalRepository.map(IRepository::getSessionManager).map(ISessionManager::getSessions).orElseGet(() -> new ISession[0]);
        return Arrays.asList(sessions).stream().anyMatch(CDORepositoryUtil::sessionIsNotSystemAndHasViewOpened);
    }

    public static List<String> getActiveRemoteUsers(String repositoryName) {
        Optional<InternalRepository> optionalRepository = CDORepositoryUtil.getRepositoryFromName(repositoryName);
        ISession[] sessions = optionalRepository.map(IRepository::getSessionManager).map(ISessionManager::getSessions).orElseGet(() -> new ISession[0]);
        ArrayList<String> activeUsers = new ArrayList<String>();
        ISession[] iSessionArray = sessions;
        int n = sessions.length;
        int n2 = 0;
        while (n2 < n) {
            ISession iSession = iSessionArray[n2];
            if (CDORepositoryUtil.sessionIsNotSystemAndHasViewOpened(iSession) && iSession.getUserID() != null) {
                activeUsers.add(iSession.getUserID());
            }
            ++n2;
        }
        return activeUsers;
    }

    private static boolean sessionIsNotSystemAndHasViewOpened(ISession session) {
        return !"CDO_SYSTEM".equals(session.getUserID()) && session.getViews().length > 0;
    }

    public static Map<String, String> convertCredentialsToProperties(List<Object> credentials) {
        LinkedHashMap<String, String> properties = new LinkedHashMap<String, String>();
        for (Object credential : credentials) {
            Map credentialMap = (Map)credential;
            properties.put((String)credentialMap.get("login"), credentialMap.getOrDefault("password", ""));
        }
        properties.put(WEB_ADMIN, "");
        return properties;
    }

    public static IStatus createRepository(NewRepository newRepository) {
        IStatus status;
        CDOServerConfigFileUtil cdoServerConfigFileUtil = CDOServerConfigFileUtil.getInstance();
        Optional<File> optionalConfigFile = cdoServerConfigFileUtil.createCDORepositoryConfigurationFile(newRepository);
        if (optionalConfigFile.isPresent()) {
            File configFile = optionalConfigFile.get();
            status = CDORepositoryUtil.startRepository(configFile, newRepository.getRepositoryName());
        } else {
            status = new Status(4, "fr.obeo.dsl.viewpoint.collab.server.admin", String.format(CREATE_REPOSITORY_CONFIGURATION_ERROR, newRepository.getRepositoryName()));
        }
        if (!status.isOK()) {
            cdoServerConfigFileUtil.cleanCDORepositoryConfigurationFile(newRepository.getRepositoryName());
        }
        return status;
    }
}

