/*
 * Decompiled with CFR 0.152.
 */
package fr.obeo.dsl.viewpoint.collab.server.admin.internal.security.usermgmt;

import fr.obeo.dsl.viewpoint.collab.server.admin.internal.security.SpecialUserAwareAuthenticator;
import fr.obeo.dsl.viewpoint.collab.server.usermgmt.api.auth.IAuthenticatorDelegate;
import fr.obeo.dsl.viewpoint.collab.server.usermgmt.api.manager.CollabFileUserManager;
import fr.obeo.dsl.viewpoint.collab.server.usermgmt.api.manager.CollabFileUserManagerConfig;
import java.util.Collections;
import java.util.List;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import org.eclipse.net4j.util.lifecycle.Lifecycle;
import org.eclipse.net4j.util.lifecycle.LifecycleUtil;
import org.eclipse.net4j.util.security.IAuthenticator;

public class CollabFileUserManagerSpecialUserAwareManager
extends CollabFileUserManager
implements IAuthenticatorDelegate,
SpecialUserAwareAuthenticator {
    private BiFunction<String, char[], Boolean> isSpecialUser;

    public CollabFileUserManagerSpecialUserAwareManager(CollabFileUserManagerConfig config) {
        super(config);
    }

    protected void initAuthenticator(CollabFileUserManagerConfig config) {
        super.initAuthenticator(config);
        this.authenticator = new CollabFileUserManagerSpecialUserAwareAuthenticator(this.authenticator);
    }

    protected void doActivate() throws Exception {
        IAuthenticator delegate;
        super.doActivate();
        if (this.authenticator instanceof CollabFileUserManagerSpecialUserAwareAuthenticator && (delegate = ((CollabFileUserManagerSpecialUserAwareAuthenticator)this.authenticator).delegateAuthenticator) instanceof Lifecycle) {
            LifecycleUtil.activate((Object)delegate);
        }
    }

    public List<String> getUsers() {
        return Collections.unmodifiableList(this.users.keySet().stream().collect(Collectors.toList()));
    }

    @Override
    public void setSpecialUserAuthenticator(BiFunction<String, char[], Boolean> isSpecialUserAuthenticator) {
        this.isSpecialUser = isSpecialUserAuthenticator;
    }

    private class CollabFileUserManagerSpecialUserAwareAuthenticator
    implements IAuthenticator,
    IAuthenticatorDelegate {
        private IAuthenticator delegateAuthenticator;

        CollabFileUserManagerSpecialUserAwareAuthenticator(IAuthenticator authenticator) {
            this.delegateAuthenticator = authenticator;
        }

        public void authenticate(String userID, char[] password) throws SecurityException {
            boolean isWebAdmin = false;
            if (CollabFileUserManagerSpecialUserAwareManager.this.isSpecialUser != null) {
                isWebAdmin = CollabFileUserManagerSpecialUserAwareManager.this.isSpecialUser.apply(userID, password);
            }
            if (!isWebAdmin) {
                this.delegateAuthenticator.authenticate(userID, password);
            }
        }

        public IAuthenticator getAuthenticator() {
            return this.delegateAuthenticator;
        }
    }
}

