/*
 * Decompiled with CFR 0.152.
 */
package fr.obeo.dsl.viewpoint.collab.server.admin.internal.security.userprofile;

import fr.obeo.dsl.viewpoint.collab.server.admin.internal.security.SpecialUserAwareAuthenticator;
import fr.obeo.dsl.viewpoint.collab.server.usermgmt.api.auth.IAuthenticatorDelegate;
import fr.obeo.dsl.viewpoint.collab.user.profile.manager.CollabUserProfileManager;
import fr.obeo.dsl.viewpoint.collab.user.profile.manager.CollabUserProfileManagerConfig;
import java.util.function.BiFunction;
import org.eclipse.emf.cdo.server.ISessionManager;
import org.eclipse.emf.cdo.server.spi.security.InternalSecurityManager;
import org.eclipse.net4j.util.container.IManagedContainer;
import org.eclipse.net4j.util.security.IAuthenticator;
import org.eclipse.net4j.util.security.IAuthenticator2;

public class CollabUserProfileSpecialUserAwareManager
extends CollabUserProfileManager
implements InternalSecurityManager,
SpecialUserAwareAuthenticator {
    private BiFunction<String, char[], Boolean> isSpecialUser;

    public CollabUserProfileSpecialUserAwareManager(CollabUserProfileManagerConfig config, IManagedContainer container) {
        super(config, container);
    }

    protected void init() {
        super.init();
        ISessionManager sessionManager = this.getRepository().getSessionManager();
        IAuthenticator oldAuthenticator = sessionManager.getAuthenticator();
        CollabUserProfileWebServiceAwareAuthenticator authenticator = new CollabUserProfileWebServiceAwareAuthenticator(oldAuthenticator);
        sessionManager.setAuthenticator((IAuthenticator)authenticator);
    }

    @Override
    public void setSpecialUserAuthenticator(BiFunction<String, char[], Boolean> isSpecialUserAuthenticator) {
        this.isSpecialUser = isSpecialUserAuthenticator;
    }

    protected class CollabUserProfileWebServiceAwareAuthenticator
    extends CollabUserProfileManager.CollabUserProfileAuthenticator
    implements IAuthenticator2,
    IAuthenticatorDelegate {
        protected CollabUserProfileWebServiceAwareAuthenticator(IAuthenticator delegateAuthenticator) {
            super((CollabUserProfileManager)CollabUserProfileSpecialUserAwareManager.this, delegateAuthenticator);
        }

        public void authenticate(String userID, char[] password) throws SecurityException {
            boolean isWebAdmin = false;
            if (CollabUserProfileSpecialUserAwareManager.this.isSpecialUser != null) {
                isWebAdmin = CollabUserProfileSpecialUserAwareManager.this.isSpecialUser.apply(userID, password);
            }
            if (!isWebAdmin) {
                super.authenticate(userID, password);
            }
        }
    }
}

