/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.net4j.protocol;

import java.io.IOException;
import org.eclipse.emf.cdo.common.protocol.CDODataInput;
import org.eclipse.emf.cdo.common.protocol.CDODataOutput;
import org.eclipse.emf.cdo.common.util.CDOCommonUtil;
import org.eclipse.emf.cdo.internal.net4j.bundle.OM;
import org.eclipse.emf.cdo.internal.net4j.protocol.CDOClientProtocol;
import org.eclipse.emf.cdo.internal.net4j.protocol.CDOClientRequest;
import org.eclipse.emf.spi.cdo.CDOSessionProtocol;
import org.eclipse.net4j.util.om.trace.ContextTracer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CDOTimeRequest<RESULT>
extends CDOClientRequest<RESULT> {
    private static final ContextTracer TRACER = new ContextTracer(OM.DEBUG_PROTOCOL, CDOTimeRequest.class);
    private CDOSessionProtocol.RepositoryTimeResult repositoryTimeResult = new CDOSessionProtocol.RepositoryTimeResult();

    public CDOTimeRequest(CDOClientProtocol protocol, short signalID) {
        super(protocol, signalID);
    }

    public CDOSessionProtocol.RepositoryTimeResult getRepositoryTimeResult() {
        return this.repositoryTimeResult;
    }

    @Override
    protected void requesting(CDODataOutput out) throws IOException {
        this.repositoryTimeResult.setRequested(System.currentTimeMillis());
        if (TRACER.isEnabled()) {
            TRACER.format("Requested: {0}", new Object[]{CDOCommonUtil.formatTimeStamp((long)this.repositoryTimeResult.getRequested())});
        }
    }

    @Override
    protected RESULT confirming(CDODataInput in) throws IOException {
        this.repositoryTimeResult.setConfirmed(System.currentTimeMillis());
        if (TRACER.isEnabled()) {
            TRACER.format("Confirmed: {0}", new Object[]{CDOCommonUtil.formatTimeStamp((long)this.repositoryTimeResult.getConfirmed())});
        }
        this.repositoryTimeResult.setIndicated(in.readXLong());
        if (TRACER.isEnabled()) {
            TRACER.format("Read indicated: {0}", new Object[]{CDOCommonUtil.formatTimeStamp((long)this.repositoryTimeResult.getIndicated())});
        }
        this.repositoryTimeResult.setResponded(in.readXLong());
        if (TRACER.isEnabled()) {
            TRACER.format("Read responded: {0}", new Object[]{CDOCommonUtil.formatTimeStamp((long)this.repositoryTimeResult.getResponded())});
        }
        return null;
    }
}

