/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.security.impl;

import java.util.Collection;
import java.util.Set;
import org.eclipse.emf.cdo.security.Group;
import org.eclipse.emf.cdo.security.Role;
import org.eclipse.emf.cdo.security.SecurityPackage;
import org.eclipse.emf.cdo.security.User;
import org.eclipse.emf.cdo.security.impl.AssigneeImpl;
import org.eclipse.emf.cdo.security.impl.DerivedList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GroupImpl
extends AssigneeImpl
implements Group {
    private EList<Group> allInheritedGroups = new DerivedList.RecursionSafe<Group, Group>(){

        @Override
        protected InternalEObject getOwner() {
            return GroupImpl.this;
        }

        @Override
        protected EStructuralFeature getFeature() {
            return SecurityPackage.Literals.GROUP__ALL_INHERITED_GROUPS;
        }

        @Override
        protected void getData(Group group, Set<Object> visited, Set<Group> result) {
            if (visited.add(group)) {
                result.add(group);
                for (Group inheritedGroup : group.getInheritedGroups()) {
                    this.getData(inheritedGroup, visited, result);
                }
            }
        }
    };
    private EList<Group> allInheritingGroups = new DerivedList.RecursionSafe<Group, Group>(){

        @Override
        protected InternalEObject getOwner() {
            return GroupImpl.this;
        }

        @Override
        protected EStructuralFeature getFeature() {
            return SecurityPackage.Literals.GROUP__ALL_INHERITING_GROUPS;
        }

        @Override
        protected void getData(Group group, Set<Object> visited, Set<Group> result) {
            if (visited.add(group)) {
                result.add(group);
                for (Group inheritingGroup : group.getInheritingGroups()) {
                    this.getData(inheritingGroup, visited, result);
                }
            }
        }
    };
    private EList<Role> allRoles = new DerivedList.RecursionSafe<Role, Group>(){

        @Override
        protected InternalEObject getOwner() {
            return GroupImpl.this;
        }

        @Override
        protected EStructuralFeature getFeature() {
            return SecurityPackage.Literals.GROUP__ALL_ROLES;
        }

        @Override
        protected void getData(Group group, Set<Object> visited, Set<Role> result) {
            if (visited.add(group)) {
                EList<Role> roles = group.getRoles();
                result.addAll((Collection<Role>)roles);
                for (Group inheritedGroup : group.getInheritedGroups()) {
                    this.getData(inheritedGroup, visited, result);
                }
            }
        }
    };

    protected GroupImpl() {
    }

    @Override
    protected EClass eStaticClass() {
        return SecurityPackage.Literals.GROUP;
    }

    @Override
    public EList<User> getUsers() {
        return (EList)this.eGet((EStructuralFeature)SecurityPackage.Literals.GROUP__USERS, true);
    }

    @Override
    public EList<Group> getInheritedGroups() {
        return (EList)this.eGet((EStructuralFeature)SecurityPackage.Literals.GROUP__INHERITED_GROUPS, true);
    }

    @Override
    public EList<Group> getInheritingGroups() {
        return (EList)this.eGet((EStructuralFeature)SecurityPackage.Literals.GROUP__INHERITING_GROUPS, true);
    }

    @Override
    public EList<Group> getAllInheritingGroups() {
        return this.allInheritingGroups;
    }

    @Override
    public EList<Group> getAllInheritedGroups() {
        return this.allInheritedGroups;
    }

    @Override
    public EList<Role> getAllRoles() {
        return this.allRoles;
    }
}

