/*
 * Decompiled with CFR 0.152.
 */
package fr.obeo.dsl.viewpoint.collab.user.profile.import_;

import fr.obeo.dsl.viewpoint.collab.user.profile.Activator;
import fr.obeo.dsl.viewpoint.collab.user.profile.internal.util.CDOURIDataHelper;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.Collections;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.cdo.eresource.CDOResource;
import org.eclipse.emf.cdo.session.CDOSession;
import org.eclipse.emf.cdo.util.CDOURIData;
import org.eclipse.emf.cdo.view.CDOView;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.net4j.util.container.FactoryNotFoundException;
import org.eclipse.net4j.util.container.IPluginContainer;
import org.eclipse.net4j.util.security.PasswordCredentialsProvider;

public class UserProfileModelImporter {
    private static final String PROPERTY_ID = "password";
    private static final String GROUP_ID = "org.eclipse.net4j.util.credentialsProviders";
    private static final String ERROR_MESSAGE = "Failed to export the user profile model : ";
    private URI localUserProfileModelResourceURI;
    private URI remoteUserProfileModelResourceURI;

    public UserProfileModelImporter(URI remoteUserProfileModelResourceURI, URI localUserProfileModelResourceURI) {
        this.remoteUserProfileModelResourceURI = remoteUserProfileModelResourceURI;
        this.localUserProfileModelResourceURI = localUserProfileModelResourceURI;
    }

    public void process(IProgressMonitor monitor) {
        try {
            monitor.beginTask("Import the user profile model", 1);
            ResourceSetImpl resourceSet = new ResourceSetImpl();
            CDOURIData remoteCDOURI = CDOURIDataHelper.createCDOURIData(this.remoteUserProfileModelResourceURI);
            String userName = null;
            char[] password = null;
            try {
                userName = URLDecoder.decode(remoteCDOURI.getUserName(), "UTF-8");
                password = URLDecoder.decode(remoteCDOURI.getPassWord(), "UTF-8").toCharArray();
            }
            catch (UnsupportedEncodingException e) {
                Activator.getDefault().getLog().log((IStatus)new Status(4, "fr.obeo.dsl.viewpoint.collab.user.profile", ERROR_MESSAGE + e.getLocalizedMessage(), (Throwable)e));
            }
            remoteCDOURI.setPassWord(null);
            remoteCDOURI.setUserName(null);
            URI uriWithoutCredential = remoteCDOURI.toURI();
            String description = String.valueOf(remoteCDOURI.getAuthority()) + "/" + remoteCDOURI.getRepositoryName();
            Object oldElement = null;
            try {
                oldElement = IPluginContainer.INSTANCE.getElement(GROUP_ID, PROPERTY_ID, description);
            }
            catch (FactoryNotFoundException factoryNotFoundException) {
                // empty catch block
            }
            IPluginContainer.INSTANCE.putElement(GROUP_ID, PROPERTY_ID, description, (Object)new PasswordCredentialsProvider(userName, password));
            try {
                Resource remoteUserProfileModelResource = resourceSet.getResource(uriWithoutCredential, true);
                Resource localUserProfileModelResource = resourceSet.createResource(this.localUserProfileModelResourceURI);
                EcoreUtil.Copier copier = new EcoreUtil.Copier();
                for (EObject content : remoteUserProfileModelResource.getContents()) {
                    EObject copy = copier.copy(content);
                    localUserProfileModelResource.getContents().add((Object)copy);
                }
                copier.copyReferences();
                try {
                    localUserProfileModelResource.save(Collections.emptyMap());
                }
                catch (IOException e) {
                    Activator.getDefault().getLog().log((IStatus)new Status(4, "fr.obeo.dsl.viewpoint.collab.user.profile", ERROR_MESSAGE + e.getLocalizedMessage(), (Throwable)e));
                }
                CDOResource cdoResource = (CDOResource)remoteUserProfileModelResource;
                CDOView cdoView = cdoResource.cdoView();
                cdoView.close();
                CDOSession session = cdoView.getSession();
                session.close();
            }
            finally {
                IPluginContainer.INSTANCE.putElement(GROUP_ID, PROPERTY_ID, description, oldElement);
            }
        }
        finally {
            monitor.done();
        }
    }
}

