/*
 * Decompiled with CFR 0.152.
 */
package fr.obeo.dsl.viewpoint.collab.user.profile.manager;

import fr.obeo.dsl.viewpoint.collab.server.usermgmt.api.auth.AbstractAuthenticatorDelegateConfig;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.eclipse.net4j.util.io.IOUtil;

public class CollabUserProfileManagerConfig
extends AbstractAuthenticatorDelegateConfig {
    public static final String KEY_PERMISSION_SEMANTIC_FILE_EXTENSION = "permissions.role.semantic.file.extensions";
    private static final String KEY_REALM_USERS_PATH = "realm.users.path";
    private static final String KEY_ADMINISTRATORS_FILE_PATH = "administrators.file.path";
    private String realmUsersPath;
    private Map<String, String> administrators = new HashMap<String, String>();
    private Collection<String> permissionSemanticFileExtensions = new LinkedHashSet<String>();

    public CollabUserProfileManagerConfig(Properties props, File configurationFolder) {
        super(props, configurationFolder);
        this.setRealmUsersPath(props.getProperty(KEY_REALM_USERS_PATH));
        this.setAdministratorsFromFile(props.getProperty(KEY_ADMINISTRATORS_FILE_PATH));
        String permissionProperty = props.getProperty(KEY_PERMISSION_SEMANTIC_FILE_EXTENSION);
        if (permissionProperty != null && !permissionProperty.isEmpty()) {
            List<String> extensions = Arrays.asList(props.getProperty(KEY_PERMISSION_SEMANTIC_FILE_EXTENSION).trim().split(","));
            for (String permissionSemanticFileExtension : extensions) {
                String trimmedExtension = permissionSemanticFileExtension.trim();
                if (trimmedExtension == null || trimmedExtension.isEmpty()) continue;
                this.permissionSemanticFileExtensions.add(trimmedExtension);
            }
        }
    }

    private void setAdministratorsFromFile(String administratorsPath) {
        Properties administratorsProperties;
        File administratorsFile = this.getAdministratorsFile(administratorsPath);
        if (administratorsFile != null && (administratorsProperties = this.getAdministratorsProperties(administratorsFile)) != null) {
            for (Map.Entry<Object, Object> prop : administratorsProperties.entrySet()) {
                Object user = prop.getKey();
                Object password = prop.getValue();
                if (!(user instanceof String)) continue;
                if (password instanceof String) {
                    this.administrators.put((String)user, (String)password);
                    continue;
                }
                if (password != null) continue;
                this.administrators.put((String)user, null);
            }
        }
    }

    private Properties getAdministratorsProperties(File administratorsFile) {
        Properties props = new Properties();
        FileInputStream fis = null;
        try {
            try {
                fis = new FileInputStream(administratorsFile);
                props.load(fis);
            }
            catch (FileNotFoundException e) {
                throw new IllegalArgumentException(String.format("Administrators file cannot be found (%s).", administratorsFile.getAbsolutePath()), e);
            }
            catch (IOException e) {
                throw new IllegalArgumentException(String.format("Administrators file cannot be loaded (%s).", administratorsFile.getAbsolutePath()), e);
            }
        }
        catch (Throwable throwable) {
            IOUtil.closeSilent(fis);
            throw throwable;
        }
        IOUtil.closeSilent((Closeable)fis);
        return props;
    }

    private File getAdministratorsFile(String administratorsPath) {
        File file = null;
        String trimmedPath = null;
        if (administratorsPath != null) {
            trimmedPath = administratorsPath.trim();
        }
        if (!(trimmedPath == null || trimmedPath.isEmpty() || (file = new File(administratorsPath)).exists() || this.getConfigurationFolder() == null || (file = new File(this.getConfigurationFolder(), administratorsPath)).exists())) {
            throw new IllegalArgumentException("Administrators file path must be a valid file.");
        }
        return file;
    }

    public String getRealmUsersPath() {
        return this.realmUsersPath;
    }

    public void setRealmUsersPath(String realmUsersPath) {
        this.realmUsersPath = realmUsersPath;
    }

    public Map<String, String> getAdministrators() {
        return this.administrators;
    }

    public void setAdministrators(Map<String, String> administrators) {
        this.administrators = administrators;
    }

    public Collection<String> getPermissionSemanticFileExtensions() {
        return this.permissionSemanticFileExtensions;
    }
}

