/*
 * Decompiled with CFR 0.152.
 */
package fr.obeo.dsl.viewpoint.collab.server.admin.jetty.customizer;

import fr.obeo.dsl.viewpoint.collab.server.admin.api.AdminServerConfigurationHelper;
import fr.obeo.dsl.viewpoint.collab.server.admin.internal.security.SecureStorageLoginService;
import fr.obeo.dsl.viewpoint.collab.server.admin.jetty.customizer.error.DefaultErrorHandler;
import java.util.Dictionary;
import org.eclipse.equinox.http.jetty.JettyCustomizer;
import org.eclipse.jetty.security.Authenticator;
import org.eclipse.jetty.security.ConstraintMapping;
import org.eclipse.jetty.security.ConstraintSecurityHandler;
import org.eclipse.jetty.security.HashLoginService;
import org.eclipse.jetty.security.LoginService;
import org.eclipse.jetty.security.SecurityHandler;
import org.eclipse.jetty.security.authentication.BasicAuthenticator;
import org.eclipse.jetty.server.handler.ErrorHandler;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.util.security.Constraint;
import org.eclipse.jetty.websocket.server.config.JettyWebSocketServletContainerInitializer;

public class RestAdminJettyCustomizer
extends JettyCustomizer {
    private static final String REST_ADMIN_REALM = "REST Admin Realm";

    public Object customizeContext(Object context, Dictionary<String, ?> settings) {
        if (context instanceof ServletContextHandler) {
            ServletContextHandler servletContext = (ServletContextHandler)context;
            servletContext.setSecurityHandler(this.createSecurityHandlerFromConfig());
            servletContext.setErrorHandler((ErrorHandler)new DefaultErrorHandler());
            JettyWebSocketServletContainerInitializer.configure((ServletContextHandler)servletContext, null);
        }
        return context;
    }

    protected SecurityHandler createSecurityHandlerFromConfig() {
        HashLoginService loginService;
        AdminServerConfigurationHelper adminServerConfigHelper = AdminServerConfigurationHelper.getInstance();
        if (Boolean.getBoolean("fr.obeo.dsl.viewpoint.collab.server.admin.jetty.realm.file")) {
            loginService = new HashLoginService(REST_ADMIN_REALM, adminServerConfigHelper.getRealmPropertiesFilePath());
        } else {
            int httpPort = adminServerConfigHelper.isHttpsEnabled() ? adminServerConfigHelper.getHttpsPort() : adminServerConfigHelper.getHttpPort();
            loginService = new SecureStorageLoginService(adminServerConfigHelper.getAdminServerConfigurationPath(), httpPort);
        }
        Constraint adminConstraint = new Constraint();
        adminConstraint.setName("BASIC");
        adminConstraint.setRoles(new String[]{"admin"});
        adminConstraint.setAuthenticate(true);
        ConstraintMapping adminConstraintMapping = new ConstraintMapping();
        adminConstraintMapping.setConstraint(adminConstraint);
        adminConstraintMapping.setPathSpec("/*");
        Constraint publicConstraint = new Constraint();
        publicConstraint.setAuthenticate(false);
        publicConstraint.setRoles(new String[0]);
        ConstraintMapping publicConstraintMapping = new ConstraintMapping();
        publicConstraintMapping.setConstraint(publicConstraint);
        publicConstraintMapping.setPathSpec("/doc/*");
        ConstraintMapping apiConstraintMapping = new ConstraintMapping();
        apiConstraintMapping.setConstraint(publicConstraint);
        apiConstraintMapping.setPathSpec("/openapi/*");
        ConstraintMapping net4jWebSocketMapping = new ConstraintMapping();
        net4jWebSocketMapping.setConstraint(publicConstraint);
        net4jWebSocketMapping.setPathSpec("/net4j/*");
        ConstraintMapping openIDSocketMapping = new ConstraintMapping();
        openIDSocketMapping.setConstraint(publicConstraint);
        openIDSocketMapping.setPathSpec("/auth/*");
        ConstraintSecurityHandler csh = new ConstraintSecurityHandler();
        csh.setAuthenticator((Authenticator)new BasicAuthenticator());
        csh.setRealmName(REST_ADMIN_REALM);
        csh.addConstraintMapping(adminConstraintMapping);
        csh.addConstraintMapping(publicConstraintMapping);
        csh.addConstraintMapping(apiConstraintMapping);
        csh.addConstraintMapping(openIDSocketMapping);
        if (!AdminServerConfigurationHelper.getInstance().removePublicConstraintFromNet4JServlet()) {
            csh.addConstraintMapping(net4jWebSocketMapping);
        }
        csh.setLoginService((LoginService)loginService);
        return csh;
    }
}

