/*
 * Decompiled with CFR 0.152.
 */
package fr.obeo.dsl.viewpoint.collab.server.usermgmt.api.auth;

import fr.obeo.dsl.viewpoint.collab.server.usermgmt.api.auth.IAuthenticatorConfig;
import fr.obeo.dsl.viewpoint.collab.server.usermgmt.internal.auth.AuthenticatorConfigFactoryRegistry;
import java.io.File;
import java.util.Map;
import java.util.Properties;

public class AbstractAuthenticatorDelegateConfig {
    private static final String AUTH_PREFIX = "auth.";
    private static final String KEY_AUTHENTICATOR_TYPE = "auth.type";
    private File configurationFolder;
    private IAuthenticatorConfig authenticatorDelegateConfig;

    public AbstractAuthenticatorDelegateConfig(Properties props, File configurationFolder) {
        this.configurationFolder = configurationFolder;
        String authenticatorType = props.getProperty(KEY_AUTHENTICATOR_TYPE);
        this.authenticatorDelegateConfig = this.createAuthenticatorConfig(authenticatorType, props);
    }

    public IAuthenticatorConfig getAuthenticatorDelegateConfig() {
        return this.authenticatorDelegateConfig;
    }

    public File getConfigurationFolder() {
        return this.configurationFolder;
    }

    private IAuthenticatorConfig createAuthenticatorConfig(String type, Properties props) {
        Properties authenticatorDelegateProperties = this.retrieveAuthenticatorDelegateConfig(type, props);
        IAuthenticatorConfig authenticatorDelegate = AuthenticatorConfigFactoryRegistry.INSTANCE.createAuthenticatorConfig(type, authenticatorDelegateProperties, this.configurationFolder);
        return authenticatorDelegate;
    }

    private Properties retrieveAuthenticatorDelegateConfig(String type, Properties props) {
        Properties authProperties = new Properties();
        for (Map.Entry<Object, Object> prop : props.entrySet()) {
            String key;
            Object keyAsObject = prop.getKey();
            if (!(keyAsObject instanceof String) || !(key = (String)keyAsObject).startsWith(AUTH_PREFIX)) continue;
            String shortKey = key.substring(AUTH_PREFIX.length());
            authProperties.put(shortKey, prop.getValue());
        }
        return authProperties;
    }
}

