/*
 * Decompiled with CFR 0.152.
 */
package fr.obeo.dsl.viewpoint.collab.server.usermgmt.api.manager;

import fr.obeo.dsl.viewpoint.collab.server.usermgmt.api.auth.IAuthenticatorConfig;
import fr.obeo.dsl.viewpoint.collab.server.usermgmt.api.auth.IAuthenticatorDelegate;
import fr.obeo.dsl.viewpoint.collab.server.usermgmt.api.manager.CollabFileUserManagerConfig;
import org.eclipse.net4j.util.lifecycle.Lifecycle;
import org.eclipse.net4j.util.lifecycle.LifecycleUtil;
import org.eclipse.net4j.util.security.FileUserManager;
import org.eclipse.net4j.util.security.IAuthenticator;
import org.eclipse.net4j.util.security.IUserManager;
import org.eclipse.net4j.util.security.UserManagerAuthenticator;

public class CollabFileUserManager
extends FileUserManager
implements IAuthenticatorDelegate {
    protected IAuthenticator authenticator;

    public CollabFileUserManager(CollabFileUserManagerConfig config) {
        this.setFileName(config.getUsersFilePath());
        this.initAuthenticator(config);
    }

    protected void initAuthenticator(CollabFileUserManagerConfig config) {
        IAuthenticatorConfig authenticatorConfig = config.getAuthenticatorDelegateConfig();
        if (authenticatorConfig != null) {
            this.authenticator = authenticatorConfig.instanciateAuthenticator();
        } else {
            this.authenticator = new UserManagerAuthenticator();
            ((UserManagerAuthenticator)this.authenticator).setUserManager((IUserManager)this);
        }
    }

    protected void doActivate() throws Exception {
        super.doActivate();
        if (this.authenticator instanceof Lifecycle) {
            LifecycleUtil.activate((Object)this.authenticator);
        }
    }

    public void authenticate(String userID, char[] password) {
        if (!this.users.containsKey(userID)) {
            throw new SecurityException("No such user: " + userID);
        }
        this.authenticator.authenticate(userID, password);
    }

    @Override
    public IAuthenticator getAuthenticator() {
        return this.authenticator;
    }
}

