/*
 * Decompiled with CFR 0.152.
 */
package fr.obeo.dsl.viewpoint.collab.server.usermgmt.internal.auth;

import fr.obeo.dsl.viewpoint.collab.server.usermgmt.api.auth.IAuthenticatorConfig;
import fr.obeo.dsl.viewpoint.collab.server.usermgmt.internal.OM;
import fr.obeo.dsl.viewpoint.collab.server.usermgmt.internal.auth.IAuthenticatorConfigFactory;
import java.io.File;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IRegistryEventListener;
import org.eclipse.core.runtime.Platform;
import org.eclipse.net4j.util.om.log.OMLogger;
import org.eclipse.net4j.util.security.AuthenticatorFactory;

public final class AuthenticatorConfigFactoryRegistry
implements IRegistryEventListener {
    public static final AuthenticatorConfigFactoryRegistry INSTANCE = new AuthenticatorConfigFactoryRegistry();
    private static final String EXTENSION_POINT = "org.eclipse.net4j.util.factories";
    private static final String ELEM_NAME = "factory";
    private static final String ATTR_PRODUCT_GROUP = "productGroup";
    private static final String ATTR_PRODUCT_GROUP_VALUE = "org.eclipse.net4j.authenticators";
    private static final String ATTR_CLASS = "class";
    private static final String ATTR_TYPE = "type";
    private Map<String, IAuthenticatorConfigFactory> registryOfDelegateAuthenticatorConfiguration = new LinkedHashMap<String, IAuthenticatorConfigFactory>();
    private IExtensionRegistry registry = Platform.getExtensionRegistry();

    private AuthenticatorConfigFactoryRegistry() {
        this.registry.addListener((IRegistryEventListener)this, EXTENSION_POINT);
        IExtension[] iExtensionArray = this.registry.getExtensionPoint(EXTENSION_POINT).getExtensions();
        int n = iExtensionArray.length;
        int n2 = 0;
        while (n2 < n) {
            IExtension extension = iExtensionArray[n2];
            this.parseExtension(extension);
            ++n2;
        }
    }

    private void parseExtension(IExtension extension) {
        IConfigurationElement[] configElements;
        IConfigurationElement[] iConfigurationElementArray = configElements = extension.getConfigurationElements();
        int n = configElements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement elem = iConfigurationElementArray[n2];
            if (ELEM_NAME.equals(elem.getName()) && ATTR_PRODUCT_GROUP_VALUE.equals(elem.getAttribute(ATTR_PRODUCT_GROUP))) {
                try {
                    AuthenticatorFactory authenticatorFactory = (AuthenticatorFactory)elem.createExecutableExtension(ATTR_CLASS);
                    String key = elem.getAttribute(ATTR_TYPE);
                    if (authenticatorFactory instanceof IAuthenticatorConfigFactory && key != null) {
                        this.registryOfDelegateAuthenticatorConfiguration.put(key, (IAuthenticatorConfigFactory)authenticatorFactory);
                    }
                }
                catch (CoreException e) {
                    OM.BUNDLE.logger().log(OMLogger.Level.WARN, (Throwable)e);
                }
            }
            ++n2;
        }
    }

    public void registerAuthenticatorDelegate(String configurationKey, IAuthenticatorConfigFactory configuration) {
        this.registryOfDelegateAuthenticatorConfiguration.put(configurationKey, configuration);
    }

    public IAuthenticatorConfig createAuthenticatorConfig(String configurationKey, Properties authProperties, File configurationFolder) {
        IAuthenticatorConfigFactory iAuthenticatorConfigDelegateFactory = this.registryOfDelegateAuthenticatorConfiguration.get(configurationKey);
        if (iAuthenticatorConfigDelegateFactory != null) {
            return iAuthenticatorConfigDelegateFactory.createAuthenticatorConfig(authProperties, configurationFolder);
        }
        return null;
    }

    public void added(IExtension[] extensions) {
        IExtension[] iExtensionArray = extensions;
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IExtension iExtension = iExtensionArray[n2];
            this.parseExtension(iExtension);
            ++n2;
        }
    }

    public void removed(IExtension[] extensions) {
        IExtension[] iExtensionArray = extensions;
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement[] configElements;
            IExtension iExtension = iExtensionArray[n2];
            IConfigurationElement[] iConfigurationElementArray = configElements = iExtension.getConfigurationElements();
            int n3 = configElements.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement elem = iConfigurationElementArray[n4];
                if (EXTENSION_POINT.equals(elem.getName())) {
                    String key = elem.getAttribute(ATTR_TYPE);
                    this.registryOfDelegateAuthenticatorConfiguration.remove(key);
                }
                ++n4;
            }
            ++n2;
        }
    }

    public void added(IExtensionPoint[] extensionPoints) {
    }

    public void removed(IExtensionPoint[] extensionPoints) {
    }
}

