/*
 * Decompiled with CFR 0.152.
 */
package fr.obeo.dsl.viewpoint.collab.server.usermgmt.internal.auth.ldap;

import fr.obeo.dsl.viewpoint.collab.server.usermgmt.api.auth.IAuthenticatorConfig;
import fr.obeo.dsl.viewpoint.collab.server.usermgmt.internal.auth.ldap.LDAPAuthenticator;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Properties;
import org.eclipse.net4j.util.security.IAuthenticator;

public class LDAPAuthenticatorConfig
implements IAuthenticatorConfig {
    private static final String TRUE = "true";
    private static final String PATTERN_USER_PART = "{user}";
    private static final String KEY_URL = "ldap.url";
    private static final String KEY_TLS_ENABLED = "ldap.tls.enabled";
    private static final String KEY_DN_PATTERN = "ldap.dn.pattern";
    private static final String KEY_FILTER = "ldap.filter";
    private static final String KEY_USER_SEARCH_FILTER = "ldap.user.search.filter";
    private static final String KEY_USER_SEARCH_BASE = "ldap.user.search.base";
    private static final String KEY_MANAGER_DN = "ldap.manager.dn";
    private static final String KEY_MANAGER_PASSWORD = "ldap.manager.password";
    private static final String KEY_TRUSTSTORE_PATH = "ldap.truststore.path";
    private static final String KEY_TRUSTSTORE_PASSPHRASE = "ldap.truststore.passphrase";
    private boolean tlsEnabled = true;
    private String url;
    private String trustStorePath;
    private char[] trustStorePassphrase;
    private Collection<String> dnPatterns;
    private String filter;
    private String userSearchBase;
    private String userSearchFilter;
    private String managerDN;
    private String managerPassword;
    private File configurationFolder;

    public LDAPAuthenticatorConfig(Properties props, File configurationFolder) {
        this.configurationFolder = configurationFolder;
        String sslEnabledValue = props.getProperty(KEY_TLS_ENABLED);
        this.setTlsEnabled(sslEnabledValue != null && TRUE.equalsIgnoreCase(sslEnabledValue));
        this.setUrl(props.getProperty(KEY_URL));
        this.setDnPatterns(this.getDnPatternsFromProperties(props));
        this.setFilter(props.getProperty(KEY_FILTER));
        this.setUserSearchBase(props.getProperty(KEY_USER_SEARCH_BASE));
        this.setUserSearchFilter(props.getProperty(KEY_USER_SEARCH_FILTER));
        this.setManagerDN(props.getProperty(KEY_MANAGER_DN));
        this.setManagerPassword(props.getProperty(KEY_MANAGER_PASSWORD));
        this.setTrustStorePath(props.getProperty(KEY_TRUSTSTORE_PATH));
        String passphraseAsString = props.getProperty(KEY_TRUSTSTORE_PASSPHRASE);
        if (passphraseAsString != null) {
            this.setTrustStorePassphrase(passphraseAsString.toCharArray());
        }
    }

    public boolean isTlsEnabled() {
        return this.tlsEnabled;
    }

    public void setTlsEnabled(boolean tlsEnabled) {
        this.tlsEnabled = tlsEnabled;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        if (url == null || url.trim().isEmpty()) {
            throw new IllegalArgumentException("LDAP URL must be specified.");
        }
        this.url = url.trim();
    }

    public String getTrustStorePath() {
        return this.trustStorePath;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setTrustStorePath(String trustStorePath) {
        String trimmedPath = null;
        if (trustStorePath != null) {
            trimmedPath = trustStorePath.trim();
        }
        if (trimmedPath == null || trimmedPath.isEmpty()) return;
        if (!new File(trustStorePath).exists()) {
            if (this.configurationFolder == null) return;
            File storeFile = new File(this.configurationFolder, trustStorePath);
            if (!storeFile.exists()) throw new IllegalArgumentException("Trust store path must be a valid file.");
            this.trustStorePath = storeFile.getAbsolutePath();
            return;
        } else {
            this.trustStorePath = trimmedPath;
        }
    }

    public char[] getTrustStorePassphrase() {
        return this.trustStorePassphrase;
    }

    public void setTrustStorePassphrase(char[] trustStorePassphrase) {
        this.trustStorePassphrase = trustStorePassphrase;
    }

    public Collection<String> getDnPatterns() {
        return this.dnPatterns;
    }

    public void setDnPatterns(Collection<String> dnPatterns) {
        this.dnPatterns = dnPatterns;
    }

    public String getFilter() {
        return this.filter;
    }

    public void setFilter(String filter) {
        this.filter = filter;
    }

    public String getUserSearchFilter() {
        return this.userSearchFilter;
    }

    public void setUserSearchFilter(String userSearchFilter) {
        this.userSearchFilter = userSearchFilter;
    }

    public String getUserSearchBase() {
        return this.userSearchBase;
    }

    public String getUserSearchFilterForUser(String userID) {
        String userSearchFilterForUser = null;
        if (this.userSearchFilter != null) {
            userSearchFilterForUser = this.userSearchFilter.replace(PATTERN_USER_PART, userID);
        }
        return userSearchFilterForUser;
    }

    public void setUserSearchBase(String userSearchBase) {
        this.userSearchBase = userSearchBase;
    }

    public String getManagerDN() {
        return this.managerDN;
    }

    public void setManagerDN(String connectionAccountDN) {
        this.managerDN = connectionAccountDN;
    }

    public String getManagerPassword() {
        return this.managerPassword;
    }

    public void setManagerPassword(String connectionAccountPassword) {
        this.managerPassword = connectionAccountPassword;
    }

    public File getConfigurationFolder() {
        return this.configurationFolder;
    }

    public void setConfigurationFolder(File configurationFolder) {
        this.configurationFolder = configurationFolder;
    }

    private Collection<String> getDnPatternsFromProperties(Properties properties) {
        ArrayList<String> patterns = new ArrayList<String>();
        for (Object keyAsObject : properties.keySet()) {
            String key;
            if (!(keyAsObject instanceof String) || !(key = (String)keyAsObject).equals(KEY_DN_PATTERN) && !key.startsWith("ldap.dn.pattern.")) continue;
            String dnPattern = properties.getProperty(key);
            if (!this.isDnPatternValid(dnPattern)) {
                throw new IllegalArgumentException("DN Pattern must include '{user}'.");
            }
            patterns.add(dnPattern.trim());
        }
        return patterns;
    }

    private boolean isDnPatternValid(String pattern) {
        return pattern != null && pattern.contains(PATTERN_USER_PART);
    }

    public Collection<String> getDistinguishedNamesForUser(String userID) {
        ArrayList<String> distinguishedNames = new ArrayList<String>();
        for (String dnPattern : this.dnPatterns) {
            if (!this.isDnPatternValid(dnPattern)) continue;
            distinguishedNames.add(dnPattern.replace(PATTERN_USER_PART, userID));
        }
        return distinguishedNames;
    }

    @Override
    public IAuthenticator instanciateAuthenticator() {
        return new LDAPAuthenticator(this);
    }
}

