/*
 * Decompiled with CFR 0.152.
 */
package com.thalesgroup.mde.melody.collab.server.repository.db.command;

import com.thalesgroup.mde.melody.collab.server.repository.db.Activator;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.eclipse.emf.cdo.server.IStoreAccessor;
import org.eclipse.emf.cdo.spi.server.CDOCommand;
import org.eclipse.emf.cdo.spi.server.InternalRepository;
import org.eclipse.net4j.db.DBUtil;
import org.eclipse.net4j.db.IDBConnectionProvider;

public class RepairInvalidRepresentationDescriptorsCDOCommand
extends CDOCommand.WithAccessor {
    public static final String CR = "\n";
    public static final String USER = "userID";
    private static final String RESULT_OK = "SUCCESS";
    private static final String RESULT_ERROR = "FAILURE";
    private List<String> repDesccdoIDs;
    private Map<String, String> dViewCDOID2numberOfValidRepresentations;
    private Connection connection;

    public RepairInvalidRepresentationDescriptorsCDOCommand() {
        super("repairInvalidRepresentationDescriptors", "repair invalid representation descriptors in the repository.", new CDOCommand.CommandParameter[]{RepairInvalidRepresentationDescriptorsCDOCommand.parameter((String)"cdoids")});
    }

    public void execute(InternalRepository repository, IStoreAccessor accessor, String[] args) throws Exception {
        this.repDesccdoIDs = new ArrayList<String>();
        this.dViewCDOID2numberOfValidRepresentations = new HashMap<String, String>();
        try {
            this.parseArgs(args);
            this.initializeConnections(repository);
            if (this.connection == null) {
                this.getInterpreter().println((Object)RESULT_ERROR);
            } else {
                this.repairRepDescWithoutRepresentation();
                this.getInterpreter().println((Object)RESULT_OK);
            }
        }
        catch (IllegalArgumentException e) {
            this.getInterpreter().println((Object)RESULT_ERROR);
        }
    }

    private void repairRepDescWithoutRepresentation() {
        for (String repDesccdoID : this.repDesccdoIDs) {
            DBUtil.execute((Connection)this.connection, (CharSequence)("DELETE FROM VIEWPOINT_DREPRESENTATIONDESCRIPTOR WHERE CDO_ID=" + repDesccdoID));
            DBUtil.execute((Connection)this.connection, (CharSequence)("DELETE FROM VIEWPOINT_DVIEW_OWNEDREPRESENTATIONDESCRIPTORS_LIST WHERE CDO_VALUE=" + repDesccdoID));
            DBUtil.execute((Connection)this.connection, (CharSequence)("DELETE FROM CDO_OBJECTS WHERE CDO_ID=" + repDesccdoID));
        }
        for (String dViewCDOId : this.dViewCDOID2numberOfValidRepresentations.keySet()) {
            DBUtil.execute((Connection)this.connection, (CharSequence)("UPDATE VIEWPOINT_DVIEW SET OWNEDREPRESENTATIONDESCRIPTORS ='" + this.dViewCDOID2numberOfValidRepresentations.get(dViewCDOId) + "' WHERE CDO_ID=" + dViewCDOId + " AND CDO_REVISED=0"));
        }
        try {
            boolean autoCommit = this.connection.getAutoCommit();
            if (!autoCommit) {
                this.connection.commit();
            }
        }
        catch (SQLException e) {
            Activator.getInstance().logError("Impossible to commit the DB modifications", e);
        }
    }

    private void initializeConnections(InternalRepository repository) {
        Optional.ofNullable(repository.getStore()).filter(IDBConnectionProvider.class::isInstance).map(IDBConnectionProvider.class::cast).ifPresent(dbStore -> {
            Connection connection = this.connection = dbStore.getConnection();
        });
    }

    private void parseArgs(String[] args) {
        String[] dViews;
        if (args.length != 1) {
            throw new IllegalArgumentException("Invalid number of arguments");
        }
        String argument = args[0];
        String[] stringArray = dViews = argument.split("_");
        int n = dViews.length;
        int n2 = 0;
        while (n2 < n) {
            String dView = stringArray[n2];
            String[] dViewArgs = dView.split("s");
            if (dViewArgs.length != 3) {
                throw new IllegalArgumentException("Invalid Argument for " + args);
            }
            this.dViewCDOID2numberOfValidRepresentations.put(dViewArgs[0], dViewArgs[2]);
            String[] dRepDescs = dViewArgs[1].split(",");
            this.repDesccdoIDs.addAll(Arrays.asList(dRepDescs));
            ++n2;
        }
    }
}

