/*
 * Decompiled with CFR 0.152.
 */
package com.thalesgroup.mde.melody.collab.server.repository.db.job;

import com.thalesgroup.mde.melody.collab.adm.services.utils.FileUtils;
import com.thalesgroup.mde.melody.collab.server.repository.db.Activator;
import com.thalesgroup.mde.melody.collab.server.repository.db.DBRepositoryUtils;
import com.thalesgroup.mde.melody.collab.server.repository.db.job.AbstractJob;
import java.io.File;
import java.io.FilenameFilter;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.emf.cdo.server.IRepository;
import org.eclipse.emf.cdo.server.internal.db.DBStore;
import org.h2.tools.Restore;

public class RestoreJob
extends AbstractJob {
    public static final String COLLAB_DB_RESTORE_FOLDER = "collab.db.restoreFolder";
    private static final String COLLAB_DB_RESTORE_RENAME_SOURCE_FILE = "collab.db.restore.rename.source.file";
    protected static final String RESTORED_EXT = ".restored";
    protected static final String RESTORED_ERROR_EXT = ".error";
    protected boolean done = false;
    protected File fileToRestore;
    protected String checksum;
    protected IRepository repository;

    public RestoreJob(IRepository repository) {
        super("Restore " + repository.getName(), System.getProperty(COLLAB_DB_RESTORE_FOLDER));
        this.repository = repository;
        this.dbStore = (DBStore)repository.getStore();
    }

    protected IStatus run(IProgressMonitor monitor) {
        IStatus status = this.validate();
        if (Status.OK_STATUS.equals(status)) {
            try {
                this.checksum = this.computeFileChecksumFromRestoreFolder();
                if (this.checksum != null) {
                    status = this.process();
                }
            }
            catch (Exception exception_p) {
                status = new Status(4, "com.thalesgroup.mde.melody.collab.server.repository.h2", String.valueOf(this.getName()) + " job will fail, please check the folder " + this.folder.getName());
                Activator.getInstance().getLog().log(status);
            }
        } else {
            Activator.getInstance().getLog().log(status);
        }
        return status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IStatus process() {
        Status status = null;
        Object object = exclusiveProcess;
        synchronized (object) {
            Activator.getInstance().log(String.valueOf(this.getName()) + " processing starts.");
            try {
                DBRepositoryUtils.dropAllTables(this.dbStore);
                if (this.fileToRestore.getName().endsWith("-bin.zip")) {
                    String directoryName = this.dbStore.getConnection().getMetaData().getURL().substring("jdbc:h2:".length());
                    directoryName = directoryName.replaceAll("(.*)/([^/]+)$", "$1");
                    Restore.execute((String)this.fileToRestore.getAbsolutePath(), (String)directoryName, null, (boolean)false);
                } else if (this.fileToRestore.getName().endsWith("-sql.zip")) {
                    DBRepositoryUtils.executeQuery(this.dbStore, "RUNSCRIPT FROM '" + this.fileToRestore.getAbsolutePath() + "' compression zip");
                } else {
                    String statusMessage = String.valueOf(this.getName()) + " job failed: backup file must ends with " + "-bin.zip" + " or " + "-sql.zip" + ". Please check the file " + this.fileToRestore.getName();
                    Activator.getInstance().logError(statusMessage);
                    status = new Status(4, "com.thalesgroup.mde.melody.collab.server.repository.h2", statusMessage);
                    return status;
                }
                Activator.getInstance().log(String.valueOf(this.getName()) + " restored database from: " + this.fileToRestore.getAbsolutePath());
            }
            catch (Exception exception_p) {
                String statusMessage = String.valueOf(this.getName()) + " job failed while processing the file " + this.fileToRestore.getName();
                Activator.getInstance().logError(statusMessage, exception_p);
                if (!"false".equalsIgnoreCase(System.getProperty(COLLAB_DB_RESTORE_RENAME_SOURCE_FILE))) {
                    this.fileToRestore.renameTo(new File(String.valueOf(this.fileToRestore.getAbsolutePath()) + RESTORED_ERROR_EXT));
                }
                status = new Status(4, "com.thalesgroup.mde.melody.collab.server.repository.h2", statusMessage, (Throwable)exception_p);
                return status;
            }
            String newFilename = String.valueOf(this.fileToRestore.getAbsolutePath()) + RESTORED_EXT;
            if (!"false".equalsIgnoreCase(System.getProperty(COLLAB_DB_RESTORE_RENAME_SOURCE_FILE))) {
                this.fileToRestore.renameTo(new File(newFilename));
                if (this.fileToRestore.exists()) {
                    this.fileToRestore.delete();
                }
            }
            String statusMessage = String.valueOf(this.getName()) + " processing ends. The file has been moved to " + newFilename;
            Activator.getInstance().log(statusMessage);
            status = new Status(0, "com.thalesgroup.mde.melody.collab.server.repository.h2", statusMessage);
            this.done = true;
        }
        return status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void done(IJobChangeEvent event) {
        super.done(event);
        Object object = exclusiveProcess;
        synchronized (object) {
            try {
                String newChecksum = this.computeFileChecksumFromRestoreFolder();
                if (this.fileToRestore != null && newChecksum != null && newChecksum.equals(this.checksum)) {
                    Activator.getInstance().log(String.valueOf(this.getName()) + " has detected the file " + this.fileToRestore.getAbsolutePath() + " in the restore folder. Please restart the server to restore the database.");
                }
                this.checksum = newChecksum;
            }
            catch (Exception exception_p) {
                Activator.getInstance().logError("ERROR: the restore process will fail, please check the folder " + this.folder.getName());
            }
        }
    }

    private synchronized String computeFileChecksumFromRestoreFolder() throws Exception {
        FilenameFilter filter = new FilenameFilter(){

            @Override
            public boolean accept(File directory, String filename) {
                return (filename.endsWith("-bin.zip") || filename.endsWith("-sql.zip")) && filename.startsWith(String.valueOf(RestoreJob.this.repository.getName()) + ".");
            }
        };
        File[] files = this.folder.listFiles(filter);
        if (files.length > 0) {
            this.fileToRestore = files[0];
            return FileUtils.getMD5Checksum((File)this.fileToRestore);
        }
        this.fileToRestore = null;
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean isDone() {
        Object object = exclusiveProcess;
        synchronized (object) {
            return this.done;
        }
    }
}

