/*
 * Decompiled with CFR 0.152.
 */
package com.thalesgroup.mde.melody.db.h2;

import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.eclipse.net4j.db.DBType;
import org.eclipse.net4j.db.DBUtil;
import org.eclipse.net4j.db.IDBConnectionProvider;
import org.eclipse.net4j.db.ddl.IDBField;
import org.eclipse.net4j.db.ddl.IDBIndex;
import org.eclipse.net4j.db.ddl.IDBTable;
import org.eclipse.net4j.spi.db.DBAdapter;

public class H2Adapter
extends DBAdapter {
    private static final String NAME = "h2-capella";
    public static final String VERSION = "1.1.114";

    public H2Adapter() {
        super(NAME, VERSION);
    }

    protected String getTypeName(IDBField field) {
        if ("description".equalsIgnoreCase(field.getName()) || "documentation".equalsIgnoreCase(field.getName())) {
            return "CLOB";
        }
        DBType type = field.getType();
        switch (type) {
            case BIT: {
                return "SMALLINT";
            }
            case FLOAT: {
                return "REAL";
            }
            case LONGVARCHAR: {
                return "VARCHAR";
            }
            case NUMERIC: {
                return "DECIMAL";
            }
            case VARBINARY: 
            case LONGVARBINARY: {
                return "BLOB";
            }
        }
        return super.getTypeName(field);
    }

    public String[] getReservedWords() {
        return this.getSQL92ReservedWords();
    }

    protected boolean isPrimaryKeyShadow(Connection connection, IDBTable table, String name, IDBIndex.Type type, IDBField[] fields) {
        if (!name.toUpperCase().startsWith("PRIMARY_KEY")) {
            return false;
        }
        return super.isPrimaryKeyShadow(connection, table, name, type, fields);
    }

    public boolean isDuplicateKeyException(SQLException ex) {
        String sqlState = ex.getSQLState();
        return "23001".equals(sqlState) || "23505".equals(sqlState);
    }

    public String sqlRenameField(IDBField field, String oldName) {
        return "ALTER TABLE " + field.getTable() + " ALTER COLUMN " + oldName + " RENAME TO " + field;
    }

    public static void createSchema(DataSource dataSource, final String name, final boolean dropIfExists) {
        DBUtil.execute((IDBConnectionProvider)DBUtil.createConnectionProvider((DataSource)dataSource), (DBUtil.RunnableWithConnection)new DBUtil.RunnableWithConnection<Object>(){

            public Object run(Connection connection) throws SQLException {
                if (dropIfExists) {
                    DBUtil.execute((Connection)connection, (CharSequence)("DROP SCHEMA IF EXISTS " + name));
                }
                DBUtil.execute((Connection)connection, (CharSequence)("CREATE SCHEMA IF NOT EXISTS " + name));
                return null;
            }
        });
    }
}

