/*
 * Decompiled with CFR 0.152.
 */
package fr.obeo.dsl.viewpoint.collab.server.warmup.internal;

import fr.obeo.dsl.viewpoint.collab.server.warmup.internal.OM;
import fr.obeo.dsl.viewpoint.collab.server.warmup.internal.ServerWarmupAppExtension;
import fr.obeo.dsl.viewpoint.collab.server.warmup.internal.ServerWarmupListener;
import fr.obeo.dsl.viewpoint.collab.server.warmup.internal.prefetch.LoadDepthRevision;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.cdo.common.branch.CDOBranchPoint;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.revision.CDOList;
import org.eclipse.emf.cdo.common.revision.CDORevision;
import org.eclipse.emf.cdo.eresource.EresourcePackage;
import org.eclipse.emf.cdo.internal.server.Repository;
import org.eclipse.emf.cdo.server.IStoreAccessor;
import org.eclipse.emf.cdo.server.StoreThreadLocal;
import org.eclipse.emf.cdo.spi.common.branch.InternalCDOBranchManager;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevision;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevisionManager;
import org.eclipse.emf.cdo.spi.server.InternalRepository;
import org.eclipse.emf.cdo.spi.server.InternalStore;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.net4j.util.concurrent.QueueWorker;
import org.eclipse.net4j.util.concurrent.Worker;
import org.eclipse.net4j.util.container.IManagedContainer;
import org.eclipse.net4j.util.event.IListener;

public class ServerWarmupWorker
extends QueueWorker<InternalRepository> {
    private static final String WARMUP_CANCELED_BRANCHING_REPOSITORY = "Warmup canceled on repository {0}: branching mode is not supported.";
    private static final String WARMUP_CANCELED_CONTEXT_FAILURE = "Warmup canceled on repository {0}: failed to build warmup context.";
    private static final String WARMUP_CANCELED_INACTIVE_REPOSITORY = "Warmup canceled on repository {0}: repository is no more active.";
    private static final String WARMUP_DONE = "Warmup done for repository {0}.";
    private static final String WARMUP_STARTED = "Warmup started on repository {0}.";
    private static final String WARMUP_IN_PROGRESS_DISCOVERED_PROJECTS = "Warmup in progress: {0} discovered potential projects.";
    private static final String WARMUP_IN_PROGRESS_PREFETCHING_RESOURCE = "Warmup in progress: Prefetching resource \"{0}\".";
    private static final String WARMUP_IN_PROGRESS_RESOURCES_TO_PREFETCH_LOOKUP = "Warmup in progress: Looking for resources to prefetch in project \"{0}\".";

    public ServerWarmupWorker() {
        this.setDaemon(true);
    }

    protected void doActivate() throws Exception {
        super.doActivate();
        IManagedContainer container = ServerWarmupAppExtension.getContainer();
        List<IListener> asList = Arrays.asList(container.getListeners());
        boolean alreadyRegistered = asList.stream().anyMatch(ServerWarmupListener.class::isInstance);
        if (!alreadyRegistered) {
            ServerWarmupListener serverWarmupListener = new ServerWarmupListener(this);
            container.addListener((IListener)serverWarmupListener);
        }
    }

    protected void doAfterActivate() throws Exception {
        Object[] elements;
        super.doAfterActivate();
        IManagedContainer container = ServerWarmupAppExtension.getContainer();
        Object[] objectArray = elements = container.getElements("org.eclipse.emf.cdo.server.repositories", "default");
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            Object element = objectArray[n2];
            if (element instanceof Repository) {
                this.addWork((Repository)element);
            }
            ++n2;
        }
    }

    protected void doDeactivate() throws Exception {
        super.doDeactivate();
        IManagedContainer container = ServerWarmupAppExtension.getContainer();
        List<IListener> asList = Arrays.asList(container.getListeners());
        asList.stream().filter(ServerWarmupListener.class::isInstance).forEach(listener -> container.removeListener(listener));
    }

    public void work(Worker.WorkContext context, InternalRepository repo) {
        this.doWarmup(repo);
    }

    private void doWarmup(InternalRepository repo) {
        String repoName = this.getName(repo);
        if (repo.isSupportingBranches()) {
            OM.LOG.info(MessageFormat.format(WARMUP_CANCELED_BRANCHING_REPOSITORY, repoName));
            return;
        }
        if (!repo.isActive()) {
            OM.LOG.info(MessageFormat.format(WARMUP_CANCELED_INACTIVE_REPOSITORY, repoName));
            return;
        }
        OM.LOG.info(MessageFormat.format(WARMUP_STARTED, repoName));
        CDOID rootResourceId = repo.getRootResourceID();
        InternalCDORevisionManager revisionManager = repo.getRevisionManager();
        InternalCDOBranchManager branchManager = repo.getBranchManager();
        if (revisionManager != null && branchManager != null) {
            CDOBranchPoint cdoBranch = branchManager.getMainBranch().getHead();
            InternalStore store = repo.getStore();
            IStoreAccessor reader = store.getReader(null);
            StoreThreadLocal.setAccessor((IStoreAccessor)reader);
            InternalCDORevision rootRevision = revisionManager.getRevision(rootResourceId, cdoBranch, -1, 0, true);
            Collection<InternalCDORevision> potentialProjects = this.prefetchRepoContentRevisions(revisionManager, cdoBranch, rootRevision);
            OM.LOG.info(MessageFormat.format(WARMUP_IN_PROGRESS_DISCOVERED_PROJECTS, potentialProjects.size()));
            potentialProjects.stream().forEach(potentialProjectRevision -> this.prefetchContentFolderRevision(revisionManager, cdoBranch, (InternalCDORevision)potentialProjectRevision));
            StoreThreadLocal.release();
            OM.LOG.info(MessageFormat.format(WARMUP_DONE, repoName));
        } else {
            OM.LOG.info(MessageFormat.format(WARMUP_CANCELED_CONTEXT_FAILURE, repoName));
        }
    }

    private Collection<InternalCDORevision> prefetchRepoContentRevisions(InternalCDORevisionManager revisionManager, CDOBranchPoint cdoBranch, InternalCDORevision repoRevision) {
        ArrayList<InternalCDORevision> potentialProjects = new ArrayList<InternalCDORevision>();
        Object contentRepo = repoRevision.getValue((EStructuralFeature)EresourcePackage.Literals.CDO_RESOURCE__CONTENTS);
        if (contentRepo instanceof CDOList) {
            for (Object firstLevelElt : (CDOList)contentRepo) {
                CDOID firstLevelEltId;
                InternalCDORevision firstLevelEltRevision;
                if (!(firstLevelElt instanceof CDOID) || !(firstLevelEltRevision = revisionManager.getRevision(firstLevelEltId = (CDOID)firstLevelElt, cdoBranch, -1, 0, true)).isResourceFolder()) continue;
                potentialProjects.add(firstLevelEltRevision);
            }
        }
        return potentialProjects;
    }

    private void prefetchContentFolderRevision(InternalCDORevisionManager revisionManager, CDOBranchPoint cdoBranch, InternalCDORevision folderRevision) {
        Object projectName = folderRevision.getValue((EStructuralFeature)EresourcePackage.Literals.CDO_RESOURCE_NODE__NAME);
        OM.LOG.info(MessageFormat.format(WARMUP_IN_PROGRESS_RESOURCES_TO_PREFETCH_LOOKUP, projectName));
        Object values = folderRevision.getValue((EStructuralFeature)EresourcePackage.Literals.CDO_RESOURCE_FOLDER__NODES);
        if (values instanceof CDOList) {
            for (Object potentialResource : (CDOList)values) {
                CDOID potentialResourceId;
                InternalCDORevision potentialResourceRevision;
                if (!(potentialResource instanceof CDOID) || !(potentialResourceRevision = revisionManager.getRevision(potentialResourceId = (CDOID)potentialResource, cdoBranch, -1, 0, true)).isResource() || potentialResourceRevision.isResourceFolder()) continue;
                Object resourceName = potentialResourceRevision.getValue((EStructuralFeature)EresourcePackage.Literals.CDO_RESOURCE_NODE__NAME);
                OM.LOG.info(MessageFormat.format(WARMUP_IN_PROGRESS_PREFETCHING_RESOURCE, resourceName));
                LoadDepthRevision loadCompleteRevision = new LoadDepthRevision(cdoBranch, -1, -1, revisionManager);
                loadCompleteRevision.prefetchRevisions(new CDORevision[]{potentialResourceRevision});
            }
        }
    }

    private String getName(InternalRepository repo) {
        if (repo instanceof Repository) {
            return repo.getName();
        }
        return repo.getUUID();
    }
}

