/*
 * Decompiled with CFR 0.152.
 */
package fr.obeo.dsl.viewpoint.collab.server.openid.internal.auth;

import fr.obeo.dsl.viewpoint.collab.server.openid.internal.auth.OpenIDAuthenticator;
import fr.obeo.dsl.viewpoint.collab.server.openid.internal.auth.OpenIDAuthenticatorConfig;
import fr.obeo.dsl.viewpoint.collab.server.usermgmt.api.auth.IAuthenticatorConfig;
import fr.obeo.dsl.viewpoint.collab.server.usermgmt.internal.auth.IAuthenticatorConfigFactory;
import fr.obeo.dsl.viewpoint.collab.server.usermgmt.internal.configuration.CollabServerConfigPropertiesHelper;
import java.io.File;
import java.util.Properties;
import org.eclipse.net4j.util.factory.IFactory;
import org.eclipse.net4j.util.factory.ProductCreationException;
import org.eclipse.net4j.util.security.AuthenticatorFactory;

public class OpenIDAuthenticatorFactory
extends AuthenticatorFactory
implements IFactory,
IAuthenticatorConfigFactory {
    public static final String AUTHENTICATOR_TYPE = "openidconnect";

    public OpenIDAuthenticatorFactory() {
        super(AUTHENTICATOR_TYPE);
    }

    public Object create(String description) throws ProductCreationException {
        OpenIDAuthenticatorConfig config = this.getConfigFromDescription(description);
        return new OpenIDAuthenticator(config);
    }

    protected OpenIDAuthenticatorConfig getConfigFromDescription(String configurationFilePath) throws ProductCreationException {
        CollabServerConfigPropertiesHelper helper = new CollabServerConfigPropertiesHelper(configurationFilePath, "OpenID authenticator");
        helper.load();
        return new OpenIDAuthenticatorConfig(helper.getProperties(), helper.getConfigFile().getParentFile());
    }

    public IAuthenticatorConfig createAuthenticatorConfig(Properties authProperties, File configurationFolder) {
        return new OpenIDAuthenticatorConfig(authProperties, configurationFolder);
    }
}

