/*
 * Decompiled with CFR 0.152.
 */
package fr.obeo.dsl.viewpoint.collab.server.openid.internal.contribution.openidconnect;

import fr.obeo.dsl.viewpoint.collab.server.admin.api.AdminServletValidator;
import fr.obeo.dsl.viewpoint.collab.server.admin.api.CommonUtil;
import fr.obeo.dsl.viewpoint.collab.server.admin.api.IRepositoryManager;
import fr.obeo.dsl.viewpoint.collab.server.admin.api.repository.RepositoryData;
import fr.obeo.dsl.viewpoint.collab.server.admin.internal.OM;
import fr.obeo.dsl.viewpoint.collab.server.admin.internal.contribution.UserProfileRepositoryManager;
import fr.obeo.dsl.viewpoint.collab.server.admin.internal.repository.CDORepositoryUtil;
import fr.obeo.dsl.viewpoint.collab.server.admin.internal.util.StringUtil;
import fr.obeo.dsl.viewpoint.collab.server.openid.internal.OpenIdConnectUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class OpenIdConnectUserProfileRepositoryManager
extends UserProfileRepositoryManager
implements IRepositoryManager {
    private static final String KEY = "OPENIDC_USERPROFILE";

    protected String createPropertiesFile(RepositoryData repositoryData) {
        String repositoryName = repositoryData.getRepositoryName();
        Map authenticationData = repositoryData.getAuthenticationData();
        String userProfileConfigurationFilePath = String.valueOf(repositoryData.getConfigurationFolderPath()) + File.separator + repositoryName + File.separator + "userprofile-config.properties";
        String administratorsPropertiesFile = String.valueOf(repositoryData.getConfigurationFolderPath()) + File.separator + repositoryName + File.separator + "administrator.properties";
        try {
            Map adminProperties = CDORepositoryUtil.convertCredentialsToProperties((List)((ArrayList)authenticationData.get("administrators")));
            CommonUtil.createProperiesFileFromMap((String)administratorsPropertiesFile, (Map)adminProperties);
        }
        catch (IOException e) {
            OM.LOG.error(String.format("The administrator properties file (%1$s) has not been created", administratorsPropertiesFile), (Throwable)e);
        }
        LinkedHashMap<String, String> userProfileProperties = new LinkedHashMap<String, String>();
        userProfileProperties.put("realm.users.path", "users.userprofile");
        userProfileProperties.put("administrators.file.path", administratorsPropertiesFile);
        userProfileProperties.putAll(OpenIdConnectUtil.addOpenIdConnectPropertiesToMap(authenticationData, false));
        try {
            CommonUtil.createProperiesFileFromMap((String)userProfileConfigurationFilePath, userProfileProperties);
        }
        catch (IOException e) {
            OM.LOG.error(String.format("The user profile configuration properties file (%1$s) has not been created", userProfileConfigurationFilePath), (Throwable)e);
        }
        String technicalUserPropertiesFile = String.valueOf(repositoryData.getConfigurationFolderPath()) + File.separator + repositoryName + File.separator + "technicalUsers.properties";
        try {
            LinkedHashMap technicalUsersProperties = new LinkedHashMap();
            CommonUtil.createProperiesFileFromMap((String)technicalUserPropertiesFile, technicalUsersProperties);
        }
        catch (IOException e) {
            OM.LOG.error(String.format("The technical users properties file (%1$s) has not been created", "technicalUsers.properties"), (Throwable)e);
        }
        return userProfileConfigurationFilePath;
    }

    public String getKey() {
        return KEY;
    }

    public String validateData(Map<String, Object> data) {
        String validatedAdministratorsData;
        String diagnostic = "NO_ISSUE_DIAGNOSTIC";
        StringBuilder detectedIssues = new StringBuilder();
        String validatedOpenIdConnectAuthenticationData = OpenIdConnectUtil.validateOpenIdConnectAuthenticationData(data);
        if (!"NO_ISSUE_DIAGNOSTIC".equals(validatedOpenIdConnectAuthenticationData)) {
            AdminServletValidator.completeDiagnostic((StringBuilder)detectedIssues, (String)validatedOpenIdConnectAuthenticationData);
        }
        if (!"NO_ISSUE_DIAGNOSTIC".equals(validatedAdministratorsData = super.validateData(data))) {
            AdminServletValidator.completeDiagnostic((StringBuilder)detectedIssues, (String)validatedAdministratorsData);
        }
        if (detectedIssues.length() > 0) {
            diagnostic = detectedIssues.toString();
        }
        return diagnostic;
    }

    protected String validateAdministrator(Map<String, Object> administrator) {
        String detectedIssues = "NO_ISSUE_DIAGNOSTIC";
        Object login = administrator.get("login");
        if (!(login instanceof String)) {
            detectedIssues = "At least one administrator login is invalid.";
        } else if (StringUtil.isEmpty((String)login.toString())) {
            detectedIssues = "At least one administrator login is empty.";
        }
        return detectedIssues;
    }

    protected boolean shouldStorePassword() {
        return false;
    }
}

