/*
 * Decompiled with CFR 0.152.
 */
package fr.obeo.dsl.viewpoint.collab.server.openid.internal.http;

import com.google.gson.Gson;
import fr.obeo.dsl.viewpoint.collab.common.internal.http.auth.AuthInformationCookie;
import fr.obeo.dsl.viewpoint.collab.common.internal.http.helper.HttpRequestHelper;
import fr.obeo.dsl.viewpoint.collab.server.admin.api.io.ErrorResponse;
import fr.obeo.dsl.viewpoint.collab.server.admin.api.io.JsonBodyWriter;
import fr.obeo.dsl.viewpoint.collab.server.admin.api.io.ResponseFactory;
import fr.obeo.dsl.viewpoint.collab.server.openid.internal.auth.OpenIDAuthenticatorConfig;
import fr.obeo.dsl.viewpoint.collab.server.openid.internal.http.AbstractAuthenticationResource;
import fr.obeo.dsl.viewpoint.collab.server.openid.internal.http.UserInfoResponse;
import fr.obeo.dsl.viewpoint.collab.server.openid.internal.user.UserAuthenticationRegistry;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Optional;
import java.util.UUID;
import javax.servlet.ServletException;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class AuthenticationRedirectResource
extends AbstractAuthenticationResource {
    public static final String ALIAS = "/auth/redirect";
    private static final String ERROR_MESSAGE = "The user can not be authenticated.";
    private static final long serialVersionUID = -4118973169902165544L;

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.doGet(req, resp);
    }

    @Override
    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String repositoryName = this.getRepositoryNameFromCookie(req);
        Optional<OpenIDAuthenticatorConfig> openIDConfigForRepository = this.getOpenIDConfigForRepository(repositoryName);
        if (repositoryName.isEmpty() || !openIDConfigForRepository.isPresent()) {
            this.sendErrorResponse(resp, "Repository information has been lost in the authentication process");
        } else {
            String accessToken = req.getParameter("access_token");
            if (accessToken != null) {
                StringBuilder responseStr = new StringBuilder();
                LinkedHashMap<String, String> requestProperties = new LinkedHashMap<String, String>();
                requestProperties.put("Authorization", "Bearer " + accessToken);
                responseStr = new StringBuilder();
                if (HttpRequestHelper.callHttpService((String)openIDConfigForRepository.get().getUserInfoEndPointURI(), (String)"GET", requestProperties, new LinkedHashMap(), (StringBuilder)responseStr)) {
                    UserInfoResponse userInfo = (UserInfoResponse)((Object)new Gson().fromJson(responseStr.toString(), UserInfoResponse.class));
                    String userId = UUID.randomUUID().toString();
                    String fullName = userInfo.getName();
                    UserAuthenticationRegistry.registerUser(userId, fullName);
                    AuthInformationCookie authInformationCookie = new AuthInformationCookie(userId, fullName);
                    String cookieValue = authInformationCookie.getCookieValue();
                    resp.addCookie(new Cookie("fr.obeo.dsl.viewpoint.collab.openidconnectInformation", cookieValue));
                    resp.sendRedirect("/auth/success");
                } else {
                    this.sendErrorResponse(resp, responseStr.toString());
                }
            } else {
                this.sendErrorResponse(resp, "The access token used to get user information is not available");
            }
        }
    }

    private void sendErrorResponse(HttpServletResponse resp, String responseStr) throws IOException {
        ErrorResponse response = ResponseFactory.createInternalServerErrorResponse((String)ERROR_MESSAGE, (String)responseStr.toString());
        resp.setStatus(response.getStatus());
        JsonBodyWriter.write((HttpServletResponse)resp, response.getClass(), (Object)response);
        resp.sendRedirect("/auth/fail");
    }
}

