/*
 * Decompiled with CFR 0.152.
 */
package fr.obeo.dsl.viewpoint.collab.server.openid.internal.http;

import fr.obeo.dsl.viewpoint.collab.server.openid.internal.OM;
import fr.obeo.dsl.viewpoint.collab.server.openid.internal.auth.OpenIDAuthenticatorConfig;
import fr.obeo.dsl.viewpoint.collab.server.openid.internal.http.AbstractAuthenticationResource;
import java.io.IOException;
import java.util.Optional;
import javax.servlet.ServletException;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class AuthenticationSigninResource
extends AbstractAuthenticationResource {
    public static final String ALIAS = "/auth/signin";
    private static final String PATTERN_OPENID_AUTHORISATION_REQUEST_URI = "OPENID_AUTHORISATION_REQUEST_URI";
    private static final String OPENID_CONNECT_HOMEPAGE = "collab.authentication.openid.homepage";
    private static final long serialVersionUID = -4118973169902165544L;

    @Override
    protected String getHtmlFileName() {
        return "resources/auth/signin.html";
    }

    @Override
    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        Cookie cookie = new Cookie("fr.obeo.dsl.viewpoint.collab.openidconnectRepositoryInformation", this.getRepositoryNameFromURI(req.getRequestURI()));
        cookie.setPath("/auth");
        resp.addCookie(cookie);
        if (!Boolean.parseBoolean(System.getProperty(OPENID_CONNECT_HOMEPAGE)) && req.getRequestURI().startsWith(ALIAS)) {
            String authenticationRequestURL = this.getAuthenticationRequestURL(req);
            resp.sendRedirect(authenticationRequestURL);
        } else {
            super.doGet(req, resp);
        }
    }

    @Override
    protected String updateHTML(HttpServletRequest req, String htmlLine) {
        String requestURI = req.getRequestURI();
        if (requestURI.startsWith(ALIAS) && htmlLine.contains(PATTERN_OPENID_AUTHORISATION_REQUEST_URI)) {
            String authenticationRequestURL = this.getAuthenticationRequestURL(req);
            if (authenticationRequestURL == null || authenticationRequestURL.isEmpty()) {
                OM.LOG.error("Error while retrieving the authentication URL");
            } else {
                return htmlLine.replace(PATTERN_OPENID_AUTHORISATION_REQUEST_URI, authenticationRequestURL);
            }
        }
        return htmlLine;
    }

    private String getRepositoryNameFromURI(String requestURI) {
        String[] split = requestURI.split("/");
        String repositoryName = split[split.length - 1];
        return repositoryName;
    }

    private String getAuthenticationRequestURL(HttpServletRequest req) {
        String repositoryName = this.getRepositoryNameFromURI(req.getRequestURI());
        Optional<OpenIDAuthenticatorConfig> openIDConfigForRepository = this.getOpenIDConfigForRepository(repositoryName);
        if (openIDConfigForRepository.isPresent()) {
            String serverURL = this.getServerURL(req);
            return openIDConfigForRepository.get().computeAuthenticationRequestURI(serverURL);
        }
        return "";
    }
}

