/*
 * Decompiled with CFR 0.152.
 */
package fr.obeo.dsl.viewpoint.collab.server.openid.internal.http;

import fr.obeo.dsl.viewpoint.collab.common.internal.http.auth.AuthInformationCookie;
import fr.obeo.dsl.viewpoint.collab.server.openid.internal.OM;
import fr.obeo.dsl.viewpoint.collab.server.openid.internal.auth.OpenIDAuthenticatorConfig;
import fr.obeo.dsl.viewpoint.collab.server.openid.internal.http.AbstractAuthenticationResource;
import java.util.Optional;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;

public class AuthenticationSuccessResource
extends AbstractAuthenticationResource {
    public static final String ALIAS = "/auth/success";
    private static final String PATTERN_OIDC_SIGNOUT_REQUEST_URI = "OIDC_SIGNOUT_REQUEST_URL";
    private static final String CONNECTED_USER = "CONNECTED_USER";
    private static final long serialVersionUID = 4120088003015651740L;

    @Override
    protected String getHtmlFileName() {
        return "resources/auth/success.html";
    }

    @Override
    protected String updateHTML(HttpServletRequest req, String htmlLine) {
        if (req.getRequestURI().startsWith(ALIAS)) {
            String returnedHtmlLine = htmlLine;
            if (htmlLine.contains(PATTERN_OIDC_SIGNOUT_REQUEST_URI)) {
                String repositoryName = this.getRepositoryNameFromCookie(req);
                String servletCommonURL = this.getServerURL(req);
                String signoutRequestURL = this.getSignOutRequestURL(servletCommonURL, repositoryName);
                if (signoutRequestURL == null || signoutRequestURL.isEmpty()) {
                    OM.LOG.error("Error while retrieving the signout URL");
                } else {
                    returnedHtmlLine = returnedHtmlLine.replace(PATTERN_OIDC_SIGNOUT_REQUEST_URI, signoutRequestURL);
                }
            }
            if (htmlLine.contains(CONNECTED_USER)) {
                String user = this.getUserFromCookie(req);
                if (user == null || user.isEmpty()) {
                    OM.LOG.error("Error while retrieving the user from the cookie fr.obeo.dsl.viewpoint.collab.openidconnectInformation");
                } else {
                    returnedHtmlLine = returnedHtmlLine.replace(CONNECTED_USER, user);
                }
            }
            return returnedHtmlLine;
        }
        return htmlLine;
    }

    private String getSignOutRequestURL(String servletCommonURL, String repositoryName) {
        Optional<OpenIDAuthenticatorConfig> openIDConfigForRepository = this.getOpenIDConfigForRepository(repositoryName);
        if (openIDConfigForRepository.isPresent()) {
            return String.valueOf(openIDConfigForRepository.get().computeSignOutRequestURL(servletCommonURL)) + repositoryName;
        }
        return "";
    }

    private String getUserFromCookie(HttpServletRequest req) {
        Cookie[] cookies;
        String userFullName = "";
        Cookie[] cookieArray = cookies = req.getCookies();
        int n = cookies.length;
        int n2 = 0;
        while (n2 < n) {
            Cookie cookie = cookieArray[n2];
            if ("fr.obeo.dsl.viewpoint.collab.openidconnectInformation".equals(cookie.getName())) {
                AuthInformationCookie authInformationCookie = AuthInformationCookie.getAuthInformationCookieFromCookieValue((String)cookie.getValue());
                userFullName = authInformationCookie.getUserName();
            }
            ++n2;
        }
        return userFullName;
    }
}

