/*******************************************************************************
 * Copyright (c) 2021 THALES GLOBAL SERVICES All rights reserved.
 * 
 * Contributors: Obeo - initial API and implementation
 *******************************************************************************/
package fr.obeo.dsl.viewpoint.collab.common.internal.http.helper;

import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Map;

import org.eclipse.core.runtime.IStatus;

import fr.obeo.dsl.viewpoint.collab.common.internal.Activator;

/**
 * Helper to call http REST service.
 * 
 * @author lfasani
 */
public final class HttpRequestHelper {

    private HttpRequestHelper() {
    }

    private static String getParamsString(Map<String, String> params) throws UnsupportedEncodingException {
        StringBuilder result = new StringBuilder();

        for (Map.Entry<String, String> entry : params.entrySet()) {
            result.append(URLEncoder.encode(entry.getKey(), "UTF-8")); //$NON-NLS-1$
            result.append("="); //$NON-NLS-1$
            result.append(URLEncoder.encode(entry.getValue(), "UTF-8")); //$NON-NLS-1$
            result.append("&"); //$NON-NLS-1$
        }

        String resultString = result.toString();
        return resultString.length() > 0 ? resultString.substring(0, resultString.length() - 1) : resultString;
    }

    /**
     * Call an http request.
     * 
     * @param fullUrl
     *            the URL to request
     * @param requestMethod
     *            the request method
     * @param requestProperties
     *            the request properties
     * @param parameters
     *            the request parameters
     * @param response
     *            the response body
     * @return true if the http return code is not a success<br>
     *         false otherwise
     */
    public static boolean callHttpService(String fullUrl, String requestMethod, Map<String, String> requestProperties, Map<String, String> parameters, StringBuilder response) {

        // TODO We should use the newer HttpClient API instead. TO CHANGE WHEN SWITCHING to Java 11
        boolean result = false;
        try {

            URL url = new URL(fullUrl);

            // Open a connection
            HttpURLConnection connection = (HttpURLConnection) url.openConnection();
            connection.setRequestMethod(requestMethod);

            // set the request properties
            for (String propertyKey : requestProperties.keySet()) {
                connection.setRequestProperty(propertyKey, requestProperties.get(propertyKey));
            }

            // set the parameters
            connection.setDoOutput(true);
            if (parameters.size() > 0) {
                DataOutputStream out = new DataOutputStream(connection.getOutputStream());
                out.writeBytes(getParamsString(parameters));
                out.flush();
                out.close();
            }

            // Do the request
            int status = connection.getResponseCode();
            Reader streamReader = null;

            if (status > 299) {
                streamReader = new InputStreamReader(connection.getErrorStream());
            } else {
                streamReader = new InputStreamReader(connection.getInputStream());
                result = true;
            }

            BufferedReader in = new BufferedReader(streamReader);
            try {
                String inputLine;
                while ((inputLine = in.readLine()) != null) {
                    response.append(inputLine);
                }
            } finally {
                in.close();
            }

        } catch (IOException e) {
            Activator.getDefault().log(IStatus.ERROR, e.getMessage(), e);
        }
        return result;
    }
}
