/*******************************************************************************
 * Copyright (c) 2022 THALES GLOBAL SERVICES and others.
 * All rights reserved.
 *
 * Contributors:
 *    Obeo - initial API and implementation
 *******************************************************************************/
package fr.obeo.dsl.viewpoint.collab.common.internal.security;

import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Optional;
import java.util.UUID;

import fr.obeo.dsl.viewpoint.collab.common.internal.Activator;

/**
 * A generator responsible to generate the new token.
 * 
 * @author fbarbin
 *
 */
public class TokenManager {

    private static final String SHA_256 = "SHA-256"; //$NON-NLS-1$

    /**
     * Generate a new token.
     * 
     * @return a new random token.
     */
    public char[] generate() {
        return UUID.randomUUID().toString().toCharArray();
    }

    /**
     * Encrypts the provided password with the SHA_256 algorithm.
     * 
     * @param password
     *            the password to encrypt.
     * @return the encrypted password.
     * @throws NoSuchAlgorithmException
     *             if no algorithm found.
     */
    public Optional<char[]> encrypt(char[] password) {
        MessageDigest msg;
        try {
            msg = MessageDigest.getInstance(SHA_256);
            byte[] hash = msg.digest(String.valueOf(password).getBytes(StandardCharsets.UTF_8));
            // we convert the bytes to hexa
            StringBuilder s = new StringBuilder();
            for (byte b : hash) {
                // b & 0xff to convert the byte b to a 32 bit integer
                // 0x100 to add a 9th leading bit to keep a 3-digit value
                // substring(1) to remove the leading bit added previously.
                s.append(Integer.toString((b & 0xff) + 0x100, 16).substring(1));
            }
            return Optional.ofNullable(s.toString().toCharArray());
        } catch (NoSuchAlgorithmException e) {
            Activator.getDefault().getLog().error("Impossible to encrypt the token.", e); //$NON-NLS-1$
        }
        return Optional.empty();
    }

}
