/*******************************************************************************
 * Copyright (c) 2021 THALES GLOBAL SERVICES
 * All rights reserved.
 *
 *******************************************************************************/
package fr.obeo.dsl.viewpoint.collab.common.user.protocol;

/**
 * A POJO class to hold information returned for ICollabProtocolConstants.SIGNAL_ID_GET_OPENID_AUTHENTIFICATION_INFO.
 * 
 * @author <a href="mailto:laurent.fasani@obeo.fr">Laurent Fasani</a>
 *
 */
public class OpenIDAuthenticationInfo {
    boolean isOpenIdConnectAuthentication;

    boolean httpsEnabled;

    int urlPort;

    /**
     * Default constructor.
     * 
     * @param isOpenIdConnectAuthentication
     *            Whether or not the authentication is OpenIDConnect
     * @param httpsEnabled
     *            Information about the URL used to access the web server for sign in page
     * @param urlPort
     *            Port of the URL used to access the web server for sign in page
     * 
     */
    public OpenIDAuthenticationInfo(boolean isOpenIdConnectAuthentication, boolean httpsEnabled, int urlPort) {
        this.isOpenIdConnectAuthentication = isOpenIdConnectAuthentication;
        this.httpsEnabled = httpsEnabled;
        this.urlPort = urlPort;
    }

    public boolean isEnabled() {
        return isOpenIdConnectAuthentication;
    }

    public boolean isHttpsEnabled() {
        return httpsEnabled;
    }

    public int getURLPort() {
        return urlPort;
    }
}
