/*
 * Decompiled with CFR 0.152.
 */
package fr.obeo.dsl.viewpoint.collab.server.openid.internal.auth;

import fr.obeo.dsl.viewpoint.collab.server.openid.internal.auth.OpenIDAuthenticatorConfig;
import fr.obeo.dsl.viewpoint.collab.server.openid.internal.user.UserAuthenticationRegistry;
import java.util.Arrays;
import org.eclipse.net4j.util.security.IAuthenticator;

public class OpenIDAuthenticator
implements IAuthenticator {
    public static final String INVALID_PASSWORD_MESSAGE = "The password does not contains the required information.";
    private static final String OPENID_SEARCH_USER_ERROR = "Error while looking up in authentication server. Search query returned no users.";
    private OpenIDAuthenticatorConfig config;

    public OpenIDAuthenticator(OpenIDAuthenticatorConfig config) {
        this.config = config;
    }

    public void authenticate(String userID, char[] password) throws SecurityException {
        if (password == null || password.length == 0 || String.valueOf(password).trim().isEmpty()) {
            throw new SecurityException(INVALID_PASSWORD_MESSAGE);
        }
        boolean authenticationSucceeded = UserAuthenticationRegistry.isUserConnected(userID, String.valueOf(password).trim());
        if (!authenticationSucceeded) {
            if (this.config.getTechnicalUsers().containsKey(userID)) {
                this.authenticateTechnicalUser(userID, password);
            } else {
                throw new SecurityException(OPENID_SEARCH_USER_ERROR);
            }
        }
    }

    private void authenticateTechnicalUser(String userID, char[] password) {
        if (!Arrays.equals(password, this.config.getTechnicalUsers().get(userID))) {
            throw new SecurityException("Access denied. Invalid credentials for the technical user.");
        }
    }

    public OpenIDAuthenticatorConfig getConfig() {
        return this.config;
    }

    public void setConfig(OpenIDAuthenticatorConfig config) {
        this.config = config;
    }
}

