/*
 * Decompiled with CFR 0.152.
 */
package fr.obeo.dsl.viewpoint.collab.server.openid.internal.auth;

import com.google.gson.Gson;
import fr.obeo.dsl.viewpoint.collab.common.internal.http.helper.HttpRequestHelper;
import fr.obeo.dsl.viewpoint.collab.server.openid.internal.OM;
import fr.obeo.dsl.viewpoint.collab.server.openid.internal.auth.DiscoverEndPointResponse;
import fr.obeo.dsl.viewpoint.collab.server.openid.internal.auth.OpenIDAuthenticator;
import fr.obeo.dsl.viewpoint.collab.server.usermgmt.api.auth.IAuthenticatorConfig;
import fr.obeo.dsl.viewpoint.collab.server.usermgmt.internal.configuration.CollabServerConfigPropertiesHelper;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import org.eclipse.net4j.util.ReflectUtil;
import org.eclipse.net4j.util.security.IAuthenticator;

public class OpenIDAuthenticatorConfig
implements IAuthenticatorConfig {
    private static final String KEY_CLIENTID = "openIDConnect.clientID";
    private static final String KEY_TENANT = "openIDConnect.tenant";
    private static final String PATTERN_TENANT = "{tenant}";
    private static final String KEY_WEB_SERVER_URL = "openIDConnect.webServerURL";
    private static final String KEY_DISCOVERY_URL = "openIDConnect.discoveryURL";
    private static final String KEY_TECHNICAL_USERS_FILE_PATH = "openIDConnect.technicalUsers.file.path";
    private File configurationFolder;
    private Properties props;
    private String clientID;
    private String tenant;
    private String webServerURL;
    private String authorizationtEndPointURL;
    private String userInfoEndPointURL;
    private String tokenEndPointURL;
    private String signoutEndpointURL;
    @ReflectUtil.ExcludeFromDump
    private Map<String, char[]> technicalUsers = new LinkedHashMap<String, char[]>();

    public OpenIDAuthenticatorConfig(Properties props, File configurationFolder) {
        this.props = props;
        this.configurationFolder = configurationFolder;
        this.setClientID(this.getPropertyValue(KEY_CLIENTID));
        this.setTenant(this.getPropertyValue(KEY_TENANT));
        this.setWebServerURL(this.getPropertyValue(KEY_WEB_SERVER_URL));
        this.readTechnicalUsers(this.getPropertyValue(KEY_TECHNICAL_USERS_FILE_PATH));
    }

    private void readTechnicalUsers(String filePath) {
        if (filePath != null) {
            CollabServerConfigPropertiesHelper helper = new CollabServerConfigPropertiesHelper(filePath, "Technical users properties file");
            helper.load();
            Properties properties = helper.getProperties();
            for (Object key : properties.keySet()) {
                Object object = properties.get(key);
                if (!(key instanceof String) || !(object instanceof String) || ((String)object).isEmpty()) continue;
                this.technicalUsers.put((String)key, ((String)object).toCharArray());
            }
        }
    }

    public Map<String, char[]> getTechnicalUsers() {
        return this.technicalUsers;
    }

    private String getPropertyValue(String propertyKey) {
        String value = this.props.getProperty(propertyKey);
        if (value != null && (value = value.trim()).endsWith("/")) {
            value = value.subSequence(0, value.length() - 1).toString();
        }
        return value;
    }

    public File getConfigurationFolder() {
        return this.configurationFolder;
    }

    public void setConfigurationFolder(File configurationFolder) {
        this.configurationFolder = configurationFolder;
    }

    public Properties getProps() {
        return this.props;
    }

    public String getClientID() {
        return this.clientID;
    }

    public void setClientID(String clientID) {
        this.clientID = clientID;
    }

    public String getTenant() {
        return this.tenant;
    }

    public void setTenant(String tenant) {
        this.tenant = tenant;
    }

    public void setWebServerURL(String webServerURL) {
        this.webServerURL = webServerURL;
    }

    public String getWebServerURL() {
        return this.webServerURL;
    }

    public String getEncodedURL(String decodedURL) {
        String encodedURL = null;
        try {
            encodedURL = URLEncoder.encode(decodedURL, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            OM.LOG.error("Error while encoding the redirection URI", (Throwable)e);
        }
        return encodedURL;
    }

    public String getAuthorizationtEndPointURI() {
        if (this.authorizationtEndPointURL == null) {
            this.exploreDiscoveryEndPoint();
        }
        return this.authorizationtEndPointURL;
    }

    public String getUserInfoEndPointURI() {
        if (this.userInfoEndPointURL == null) {
            this.exploreDiscoveryEndPoint();
        }
        return this.userInfoEndPointURL;
    }

    public String getTokenEndPointURI() {
        if (this.tokenEndPointURL == null) {
            this.exploreDiscoveryEndPoint();
        }
        return this.tokenEndPointURL;
    }

    public void setAuthorizationtURI(String authorizationtURI) {
        this.authorizationtEndPointURL = authorizationtURI;
    }

    private void exploreDiscoveryEndPoint() {
        String patternDiscoveryURL = this.getPropertyValue(KEY_DISCOVERY_URL);
        if (!this.getTenant().isEmpty() && patternDiscoveryURL.contains(PATTERN_TENANT)) {
            patternDiscoveryURL = patternDiscoveryURL.replace(PATTERN_TENANT, this.getTenant());
        }
        StringBuilder responseStr = new StringBuilder();
        HttpRequestHelper.callHttpService((String)patternDiscoveryURL, (String)"GET", new LinkedHashMap(), new LinkedHashMap(), (StringBuilder)responseStr);
        DiscoverEndPointResponse discoveryResponse = (DiscoverEndPointResponse)new Gson().fromJson(responseStr.toString(), DiscoverEndPointResponse.class);
        this.authorizationtEndPointURL = discoveryResponse.getAuthorization_endpoint();
        this.userInfoEndPointURL = discoveryResponse.getUserinfo_endpoint();
        this.tokenEndPointURL = discoveryResponse.getToken_endpoint();
        this.signoutEndpointURL = discoveryResponse.getEnd_session_endpoint();
    }

    public String computeAuthenticationRequestURI(String computedServerUrl) {
        String serverUrlToUse = this.getServerURL(computedServerUrl);
        String computedURL = this.getAuthorizationtEndPointURI();
        computedURL = String.valueOf(computedURL) + "?client_id=" + this.getClientID();
        computedURL = String.valueOf(computedURL) + "&response_type=" + this.getEncodedURL("id_token token");
        computedURL = String.valueOf(computedURL) + "&redirect_uri=" + this.getEncodedURL(String.valueOf(serverUrlToUse) + "/auth/redirect");
        computedURL = String.valueOf(computedURL) + "&scope=openid+profile+email";
        computedURL = String.valueOf(computedURL) + "&nonce=" + UUID.randomUUID();
        computedURL = String.valueOf(computedURL) + "&response_mode=form_post";
        return computedURL;
    }

    private String getServerURL(String computedServerUrl) {
        String serverUrlToUse = computedServerUrl;
        if (this.webServerURL != null && !this.webServerURL.isEmpty()) {
            serverUrlToUse = this.webServerURL;
        }
        return serverUrlToUse;
    }

    public String computeSignOutRequestURL(String computedServerUrl) {
        String serverUrlToUse = this.getServerURL(computedServerUrl);
        String signoutURL = this.signoutEndpointURL;
        signoutURL = String.valueOf(signoutURL) + "?post_logout_redirect_uri=" + this.getEncodedURL(String.valueOf(serverUrlToUse) + "/auth/signin/");
        return signoutURL;
    }

    public IAuthenticator instanciateAuthenticator() {
        return new OpenIDAuthenticator(this);
    }
}

